/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionBuilder<V, C extends Collection<V>> {
    private final C _collection;

    public static <V> CollectionBuilder<V, ArrayList<V>> list(V ... v) {
        return CollectionBuilder.builder(new ArrayList()).addAll(v);
    }

    public static <V> CollectionBuilder<V, HashSet<V>> set(V ... v) {
        return CollectionBuilder.builder(new HashSet()).addAll(v);
    }

    public static <V> CollectionBuilder<V, TreeSet<V>> sortedSet(V ... v) {
        return CollectionBuilder.builder(new TreeSet()).addAll(v);
    }

    public static <V> CollectionBuilder<V, ArrayList<V>> list(Class<V> cls) {
        return CollectionBuilder.builder(new ArrayList());
    }

    public static <V> CollectionBuilder<V, HashSet<V>> set(Class<V> cls) {
        return CollectionBuilder.builder(new HashSet());
    }

    public static <V> CollectionBuilder<V, TreeSet<V>> sortedSet(Class<V> cls) {
        return CollectionBuilder.builder(new TreeSet());
    }

    public static <V, C extends Collection<V>> CollectionBuilder<V, C> builder(C collection) {
        return new CollectionBuilder<V, C>(collection);
    }

    protected CollectionBuilder(C collection) {
        if (collection == null) {
            throw new NullPointerException("collection");
        }
        this._collection = collection;
    }

    public C get() {
        return this._collection;
    }

    public CollectionBuilder<V, C> add(V e) {
        this._collection.add(e);
        return this;
    }

    public CollectionBuilder<V, C> addAll(Collection<? extends V> c) {
        this._collection.addAll(c);
        return this;
    }

    public CollectionBuilder<V, C> addAll(V ... e) {
        this._collection.addAll(Arrays.asList(e));
        return this;
    }
}

