/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.io;

import at.molindo.utils.io.CharsetUtils;
import at.molindo.utils.io.Compression;
import at.molindo.utils.io.StreamUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class FileUtils {
    private FileUtils() {
        throw new IllegalStateException("bad boy!");
    }

    public static String extension(File file) {
        return FileUtils.extension(file.getName());
    }

    public static String extension(String fileName) {
        int idx = fileName.lastIndexOf(".");
        return idx == -1 ? "" : fileName.substring(idx, fileName.length()).trim().toLowerCase();
    }

    public static String extensionFull(File file) {
        return FileUtils.extensionFull(file.getName());
    }

    public static String extensionFull(String fileName) {
        int idx = fileName.indexOf(".");
        return idx == -1 ? "" : fileName.substring(idx, fileName.length()).trim().toLowerCase();
    }

    public static InputStream in(File file, Compression compression) throws FileNotFoundException, IOException {
        if (Compression.AUTO == compression) {
            compression = FileUtils.compression(file);
        }
        return StreamUtils.decompress(new FileInputStream(file), compression);
    }

    public static OutputStream out(File file, Compression compression) throws FileNotFoundException, IOException {
        if (Compression.AUTO == compression) {
            compression = FileUtils.compression(file);
        }
        return StreamUtils.compress(new FileOutputStream(file), compression);
    }

    public static BufferedReader read(File file, Compression compression) throws FileNotFoundException, IOException {
        return new BufferedReader(new InputStreamReader(FileUtils.in(file, compression), CharsetUtils.UTF_8));
    }

    public static BufferedWriter write(File file, Compression compression) throws FileNotFoundException, IOException {
        return new BufferedWriter(new OutputStreamWriter(FileUtils.out(file, compression), CharsetUtils.UTF_8));
    }

    public static byte[] bytes(File file) throws FileNotFoundException, IOException {
        return FileUtils.bytes(file, FileUtils.compression(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(File file, Compression compression) throws FileNotFoundException, IOException {
        InputStream in = FileUtils.in(file, compression);
        try {
            byte[] byArray = StreamUtils.bytes(in);
            return byArray;
        }
        finally {
            StreamUtils.close((Closeable)in);
        }
    }

    public static Compression compression(File file) {
        return FileUtils.compression(file.getName());
    }

    public static Compression compression(String name) {
        if (name.endsWith(".gz")) {
            return Compression.GZIP;
        }
        if (name.endsWith(".bz2")) {
            return Compression.BZIP2;
        }
        return Compression.NONE;
    }
}

