/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorUtils {
    public static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    private IteratorUtils() {
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iter) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iter;
            }
        };
    }

    public static <T> T next(Iterator<T> iter) {
        return iter == null || !iter.hasNext() ? null : (T)iter.next();
    }

    public static <T> ArrayList<T> list(Iterator<T> iter) {
        return IteratorUtils.addAll(new ArrayList(), iter);
    }

    public static <T> ArrayList<T> list(Iterator<T> iter, int initialCapacity) {
        return IteratorUtils.addAll(new ArrayList(initialCapacity), iter);
    }

    public static <T, C extends Collection<T>> C addAll(C collection, Iterator<T> iter) {
        while (iter.hasNext()) {
            collection.add(iter.next());
        }
        return collection;
    }

    public static <T> Iterator<T> empty() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterable<T> cast(Class<T> cls, Object[] list) {
        return IteratorUtils.cast(cls, Arrays.asList(list));
    }

    public static <T> Iterable<T> cast(final Class<T> cls, final Iterable<?> iterable) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<?> _iter;
                    {
                        this._iter = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._iter.hasNext();
                    }

                    @Override
                    public T next() {
                        return cls.cast(this._iter.next());
                    }

                    @Override
                    public void remove() {
                        this._iter.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterator<T> skip(Iterator<T> iter, int skip) {
        while (skip-- > 0 && iter.hasNext()) {
            iter.next();
        }
        return iter;
    }

    public static <T> Iterator<T> max(final Iterator<T> iter, final int max) {
        return new Iterator<T>(){
            int _remaining;
            {
                this._remaining = max;
            }

            @Override
            public boolean hasNext() {
                return this._remaining > 0 && iter.hasNext();
            }

            @Override
            public T next() {
                if (this._remaining <= 0) {
                    throw new NoSuchElementException();
                }
                --this._remaining;
                return iter.next();
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }
}

