/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static <E> Set<E> unmodifiableSet(Iterable<E> e) {
        return Collections.unmodifiableSet(CollectionUtils.set(e));
    }

    public static <E> Set<E> unmodifiableSet(E ... e) {
        return Collections.unmodifiableSet(CollectionUtils.set(e));
    }

    public static <E> HashSet<E> set(E ... e) {
        return CollectionUtils.set(Arrays.asList(e));
    }

    public static <E> HashSet<E> set(Iterable<E> e) {
        return IteratorUtils.addAll(new HashSet(), e.iterator());
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(E ... e) {
        return Collections.unmodifiableSortedSet(CollectionUtils.sortedSet(e));
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(Iterable<E> e) {
        return Collections.unmodifiableSortedSet(CollectionUtils.sortedSet(e));
    }

    public static <E> TreeSet<E> sortedSet(E ... e) {
        return CollectionUtils.sortedSet(Arrays.asList(e));
    }

    public static <E> TreeSet<E> sortedSet(Iterable<E> e) {
        return IteratorUtils.addAll(new TreeSet(), e.iterator());
    }

    public static <E> List<E> unmodifiableList(E ... e) {
        return Collections.unmodifiableList(CollectionUtils.list(e));
    }

    public static <E> List<E> unmodifiableList(Iterable<E> e) {
        return Collections.unmodifiableList(CollectionUtils.list(e));
    }

    public static <E> ArrayList<E> list(E ... e) {
        return new ArrayList<E>(Arrays.asList(e));
    }

    public static <E> ArrayList<E> list(Iterable<E> e) {
        return IteratorUtils.addAll(new ArrayList(), e.iterator());
    }

    public static <T> List<T> subList(List<T> list, int first, int count) {
        if (list.size() < first) {
            return new ArrayList(0);
        }
        return list.subList(first, Math.min(first + count, list.size()));
    }

    public static boolean empty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean empty(Map<?, ?> c) {
        return c == null || c.isEmpty();
    }

    public static <T> T first(Collection<T> c) {
        return c == null ? null : (T)IteratorUtils.next(c.iterator());
    }

    public static <K, V> Map.Entry<K, V> first(Map<K, V> c) {
        return c == null ? null : IteratorUtils.next(c.entrySet().iterator());
    }

    public static <K> K firstKey(Map<K, ?> c) {
        return c == null ? null : (K)IteratorUtils.next(c.keySet().iterator());
    }

    public static <V> V firstValue(Map<?, V> c) {
        return c == null ? null : (V)IteratorUtils.next(c.values().iterator());
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V current = map.putIfAbsent(key, value);
        return current != null ? current : value;
    }
}

