/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations.lib;

import at.molindo.mysqlcollations.lib.Collation;
import at.molindo.utils.io.StreamUtils;
import at.molindo.utils.properties.SystemProperty;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class CollationCompare {
    private CollationCompare() {
    }

    static native int index(String var0);

    static native int compareBytes(int var0, byte[] var1, byte[] var2);

    static {
        String dirName = System.getProperty(Collation.PROP_LIB_COLLATION_COMPARE_DIR, ".");
        String fileName = System.getProperty(Collation.PROP_LIB_COLLATION_COMPARE_NAME, "libCollationCompare." + SystemProperty.OS_ARCH + ".so");
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new RuntimeException("directory does not exist: " + dir.getAbsolutePath());
        }
        File file = new File(dir, fileName);
        if (file.exists()) {
            file.delete();
        }
        InputStream in = CollationCompare.class.getResourceAsStream("/" + fileName);
        BufferedOutputStream out = null;
        if (in == null) {
            throw new RuntimeException("can't find /" + fileName + " on classpath");
        }
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("can't write library to " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                StreamUtils.close((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
        }
        StreamUtils.close((Closeable[])new Closeable[]{in, out});
        Runtime.getRuntime().load(file.getAbsolutePath());
        System.setProperty(Collation.PROP_LIB_COLLATION_COMPARE_LOADED, file.getAbsolutePath());
        file.delete();
    }
}

