/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.mysqlcollations.lib;

import at.molindo.mysqlcollations.lib.CollationCompare;
import at.molindo.mysqlcollations.lib.CollationList;
import at.molindo.utils.data.StringUtils;
import com.mysql.jdbc.CharsetMapping;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Comparator;
import java.util.Iterator;

public class Collation
implements Comparator<String> {
    private static final String PREFIX = Collation.class.getName() + ".";
    public static final String PROP_LIB_COLLATION_COMPARE_NAME = PREFIX + "name";
    public static final String PROP_LIB_COLLATION_COMPARE_DIR = PREFIX + "dir";
    public static final String PROP_LIB_COLLATION_COMPARE_ALL = PREFIX + "all";
    static final String PROP_LIB_COLLATION_COMPARE_LOADED = PREFIX + "loaded";
    private final int _index;
    private final String _name;
    private final Charset _charset;

    public static void setLibraryDirectoryName(String name) {
        if (System.getProperty(PROP_LIB_COLLATION_COMPARE_LOADED) != null) {
            throw new IllegalStateException("library already loaded");
        }
        System.setProperty(PROP_LIB_COLLATION_COMPARE_DIR, name);
    }

    public static void setLibraryFileName(String name) {
        if (System.getProperty(PROP_LIB_COLLATION_COMPARE_LOADED) != null) {
            throw new IllegalStateException("library already loaded");
        }
        System.setProperty(PROP_LIB_COLLATION_COMPARE_NAME, name);
    }

    public static Collation get(String collation) {
        if (collation == null) {
            throw new NullPointerException("collation");
        }
        int idx = CollationCompare.index(collation);
        if (idx <= 0) {
            throw new IllegalArgumentException("unknown collation: " + collation);
        }
        return Collation.get(idx);
    }

    public static Collation get(int idx) {
        return CollationList.collation(idx);
    }

    public static Iterator<Collation> iterator() {
        return CollationList.iterator();
    }

    private static Charset charset(String collationName) {
        try {
            String charsetName = StringUtils.beforeFirst((String)collationName, (String)"_");
            String mappedName = (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(charsetName);
            if (mappedName != null) {
                charsetName = mappedName;
            }
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return null;
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    Collation(int idx, String name) {
        if (idx <= 0) {
            throw new IllegalArgumentException("idx <= 0 (" + idx + ")");
        }
        this._index = idx;
        this._name = name;
        this._charset = Collation.charset(name);
    }

    public int getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public Charset getCharset() {
        return this._charset;
    }

    @Override
    public int compare(String o1, String o2) {
        if (this._charset == null) {
            throw new IllegalStateException("can't compare collation without mapped Java charset: " + this._name);
        }
        int cmp = CollationCompare.compareBytes(this._index, o1.getBytes(this._charset), o2.getBytes(this._charset));
        if (cmp < -1 || cmp > 1) {
            throw new IllegalArgumentException("can't compare strings '" + o1 + "' and '" + o2 + "' using collation#" + this._index + " (" + cmp + ")");
        }
        return cmp;
    }
}

