/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Maps;
import com.spotify.helios.common.Json;
import com.spotify.helios.testing.descriptors.TemporaryJobEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryJobReports {
    private static final Logger log = LoggerFactory.getLogger(TemporaryJobReports.class);
    private final Path outputDir;

    TemporaryJobReports(Path outputDir) {
        this.outputDir = outputDir;
        this.outputDir.toFile().mkdirs();
    }

    public ReportWriter getWriterForTest(Description testDescription) {
        return new ReportWriter(this.outputDir, testDescription.getClassName(), testDescription.getMethodName());
    }

    public ReportWriter getWriterForStream(OutputStream outputStream) {
        return new ReportWriter(outputStream);
    }

    public static class Step {
        private final ReportWriter reportWriter;
        private final String step;
        private final long timestampMillis;
        private final Map<String, Object> tags;
        private boolean success = false;

        Step(ReportWriter reportWriter, String step) {
            this.reportWriter = reportWriter;
            this.step = step;
            this.timestampMillis = System.currentTimeMillis();
            this.tags = Maps.newHashMap();
        }

        public Step tag(String key, Object value) {
            this.tags.put(key, value);
            return this;
        }

        public Step markSuccess() {
            this.success = true;
            return this;
        }

        public void finish() {
            long durationMillis = System.currentTimeMillis() - this.timestampMillis;
            double timestamp = (double)this.timestampMillis / 1000.0;
            double duration = (double)durationMillis / 1000.0;
            this.reportWriter.writeEvent(this.step, timestamp, duration, this.success, this.tags);
        }
    }

    public static class ReportWriter
    implements Closeable {
        private final JsonGenerator jg;
        private final String testClassName;
        private final String testName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReportWriter(Path outputDir, String testClassName, String testName) {
            this.testClassName = testClassName;
            this.testName = testName;
            String logFilename = String.format("%s.%s.json", testClassName, testName).replace('$', '_');
            File logFile = outputDir.resolve(logFilename).toFile();
            JsonGenerator jg = null;
            try {
                jg = new JsonFactory().createGenerator(logFile, JsonEncoding.UTF8);
                jg.writeStartArray();
            }
            catch (IOException e) {
                log.error("exception creating event log: {} - {}", (Object)logFile.getAbsolutePath(), (Object)e);
            }
            finally {
                this.jg = jg;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReportWriter(OutputStream outputStream) {
            this.testClassName = null;
            this.testName = null;
            JsonGenerator jg = null;
            try {
                jg = new JsonFactory().createGenerator(outputStream, JsonEncoding.UTF8);
            }
            catch (IOException e) {
                log.error("exception creating event log: {}", (Throwable)e);
            }
            finally {
                this.jg = jg;
            }
        }

        public Step step(String step) {
            return new Step(this, step);
        }

        private void writeEvent(String step, double timestamp, double duration, Boolean success, Map<String, Object> tags) {
            TemporaryJobEvent event = new TemporaryJobEvent(timestamp, duration, this.testClassName, this.testName, step, success, tags);
            this.writeEvent(event);
        }

        private void writeEvent(TemporaryJobEvent event) {
            if (this.jg == null) {
                return;
            }
            try {
                Json.writer().writeValue(this.jg, (Object)event);
            }
            catch (IOException e) {
                log.error("exception writing event to log: {} - {}", (Object)event, (Object)e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jg != null) {
                this.jg.close();
            }
        }
    }
}

