/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.spotify.helios.testing.HostPickingStrategy;
import java.util.List;
import java.util.Random;

public class HostPickingStrategies {
    private static Random getSeededRandom(String key) {
        Random randomGenerator = new Random();
        randomGenerator.setSeed(key.hashCode());
        return randomGenerator;
    }

    public static HostPickingStrategy random() {
        return new RandomHostPickingStrategy(new Random());
    }

    public static HostPickingStrategy randomOneHost() {
        return new RandomOneHostPickingStrategy(new Random());
    }

    public static HostPickingStrategy deterministic(String key) {
        return new RandomHostPickingStrategy(HostPickingStrategies.getSeededRandom(key));
    }

    public static HostPickingStrategy deterministicOneHost(String key) {
        return new RandomOneHostPickingStrategy(HostPickingStrategies.getSeededRandom(key));
    }

    private static class RandomOneHostPickingStrategy
    implements HostPickingStrategy {
        private final double random;

        RandomOneHostPickingStrategy(Random randomGenerator) {
            this.random = randomGenerator.nextDouble();
        }

        @Override
        public String pickHost(List<String> hosts) {
            Double index = Math.floor(this.random * (double)hosts.size());
            return hosts.get(index.intValue());
        }
    }

    private static class RandomHostPickingStrategy
    implements HostPickingStrategy {
        private final Random random;

        public RandomHostPickingStrategy(Random random) {
            this.random = random;
        }

        @Override
        public String pickHost(List<String> hosts) {
            return hosts.get(this.random.nextInt(hosts.size()));
        }
    }
}

