/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.testing.Deployer;
import com.spotify.helios.testing.HostPickingStrategy;
import com.spotify.helios.testing.Prober;
import com.spotify.helios.testing.TemporaryJob;
import com.spotify.helios.testing.TemporaryJobReports;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeployer.class);
    private final HeliosClient client;
    private final List<TemporaryJob> jobs;
    private final HostPickingStrategy hostPicker;
    private final String jobDeployedMessageFormat;
    private final long deployTimeoutMillis;
    private boolean readyToDeploy;

    public DefaultDeployer(HeliosClient client, List<TemporaryJob> jobs, HostPickingStrategy hostPicker, String jobDeployedMessageFormat, long deployTimeoutMillis) {
        this.client = client;
        this.jobs = jobs;
        this.hostPicker = hostPicker;
        this.jobDeployedMessageFormat = jobDeployedMessageFormat;
        this.deployTimeoutMillis = deployTimeoutMillis;
    }

    @Override
    public TemporaryJob deploy(Job job, String hostFilter, Set<String> waitPorts, Prober prober, TemporaryJobReports.ReportWriter reportWriter) {
        List hosts;
        if (Strings.isNullOrEmpty((String)hostFilter)) {
            Assert.fail((String)"a host filter pattern must be passed to hostFilter(), or one must be specified in HELIOS_HOST_FILTER");
        }
        TemporaryJobReports.Step determineHosts = reportWriter.step("get hosts").tag("hostFilter", hostFilter);
        try {
            log.info("Getting list of hosts");
            hosts = (List)this.client.listHosts().get();
            determineHosts.markSuccess();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Failed to get list of Helios hosts", e);
        }
        finally {
            determineHosts.finish();
        }
        ImmutableList filteredHosts = FluentIterable.from((Iterable)hosts).filter(Predicates.containsPattern((String)hostFilter)).toList();
        if (filteredHosts.isEmpty()) {
            Assert.fail((String)String.format("no hosts matched the filter pattern - %s", hostFilter));
        }
        String chosenHost = this.pickHost((List<String>)filteredHosts);
        return this.deploy(job, Arrays.asList(chosenHost), waitPorts, prober, reportWriter);
    }

    @VisibleForTesting
    String pickHost(List<String> filteredHosts) {
        ArrayList mutatedList = Lists.newArrayList(filteredHosts);
        while (true) {
            String candidateHost = this.hostPicker.pickHost(mutatedList);
            try {
                if (HostStatus.Status.UP == ((HostStatus)this.client.hostStatus(candidateHost).get()).getStatus()) {
                    return candidateHost;
                }
                mutatedList.remove(candidateHost);
                if (!mutatedList.isEmpty()) continue;
                Assert.fail((String)"all hosts matching filter pattern are DOWN");
            }
            catch (InterruptedException | ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    @Override
    public TemporaryJob deploy(Job job, List<String> hosts, Set<String> waitPorts, Prober prober, TemporaryJobReports.ReportWriter reportWriter) {
        if (!this.readyToDeploy) {
            Assert.fail((String)"deploy() must be called in a @Before or in the test method, or perhaps you forgot to put @Rule before TemporaryJobs");
        }
        if (hosts.isEmpty()) {
            Assert.fail((String)"at least one host must be explicitly specified, or deploy() must be called with no arguments to automatically select a host");
        }
        log.info("Deploying {} to {}", (Object)job.getImage(), (Object)Joiner.on((String)", ").skipNulls().join(hosts));
        TemporaryJob temporaryJob = new TemporaryJob(this.client, prober, reportWriter, job, hosts, waitPorts, this.jobDeployedMessageFormat, this.deployTimeoutMillis);
        this.jobs.add(temporaryJob);
        temporaryJob.deploy();
        return temporaryJob;
    }

    @Override
    public void readyToDeploy() {
        this.readyToDeploy = true;
    }
}

