/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing.descriptors;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"step", "timestamp", "duration", "success", "testClassName", "testName"})
public class TemporaryJobEvent {
    private final double timestamp;
    private final double duration;
    private final String testClassName;
    private final String testName;
    private final String step;
    private final Boolean success;
    private final Map<String, Object> tags;

    public TemporaryJobEvent(@JsonProperty(value="timestamp") double timestamp, @JsonProperty(value="duration") double duration, @JsonProperty(value="testClassName") String testClassName, @JsonProperty(value="testName") String testName, @JsonProperty(value="step") String step, @JsonProperty(value="success") @Nullable Boolean success, @JsonProperty(value="tags") @Nullable Map<String, Object> tags) {
        this.timestamp = timestamp;
        this.duration = duration;
        this.testClassName = testClassName;
        this.testName = testName;
        this.step = step;
        this.success = success;
        this.tags = tags != null ? ImmutableMap.copyOf(tags) : ImmutableMap.of();
    }

    public double getDuration() {
        return this.duration;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getStep() {
        return this.step;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("duration", this.duration).add("testClassName", (Object)this.testClassName).add("testName", (Object)this.testName).add("step", (Object)this.step).add("success", (Object)this.success).add("tags", this.tags).toString();
    }
}

