/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.testing;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Futures;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.JobStatus;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.common.descriptors.ThrottleState;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.testing.Jobs;
import com.spotify.helios.testing.Polling;
import com.spotify.helios.testing.Prober;
import com.spotify.helios.testing.TemporaryJobReports;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.text.StrSubstitutor;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryJob {
    private static final Logger log = LoggerFactory.getLogger(TemporaryJob.class);
    private final Map<String, TaskStatus> statuses = Maps.newHashMap();
    private final HeliosClient client;
    private final Prober prober;
    private final TemporaryJobReports.ReportWriter reportWriter;
    private final Job job;
    private final List<String> hosts;
    private final Map<String, String> hostToIp = Maps.newHashMap();
    private final Set<String> waitPorts;
    private final String jobDeployedMessageFormat;
    private final long deployTimeoutMillis;

    TemporaryJob(HeliosClient client, Prober prober, TemporaryJobReports.ReportWriter reportWriter, Job job, List<String> hosts, Set<String> waitPorts, String jobDeployedMessageFormat, long deployTimeoutMillis) {
        this.client = (HeliosClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.prober = (Prober)Preconditions.checkNotNull((Object)prober, (Object)"prober");
        this.reportWriter = (TemporaryJobReports.ReportWriter)Preconditions.checkNotNull((Object)reportWriter, (Object)"reportWriter");
        this.job = (Job)Preconditions.checkNotNull((Object)job, (Object)"job");
        this.hosts = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hosts, (Object)"hosts")));
        this.waitPorts = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(waitPorts, (Object)"waitPorts")));
        this.jobDeployedMessageFormat = (String)Optional.fromNullable((Object)jobDeployedMessageFormat).or((Object)"");
        this.deployTimeoutMillis = deployTimeoutMillis;
    }

    public Job job() {
        return this.job;
    }

    public List<String> hosts() {
        return this.hosts;
    }

    public Map<String, TaskStatus> statuses() {
        return ImmutableMap.copyOf(this.statuses);
    }

    public Integer port(String host, String port) {
        Preconditions.checkArgument((boolean)this.hosts.contains(host), (String)"host %s not found", (Object[])new Object[]{host});
        Preconditions.checkArgument((boolean)this.job.getPorts().containsKey(port), (String)"port %s not found", (Object[])new Object[]{port});
        TaskStatus status = this.statuses.get(host);
        if (status == null) {
            return null;
        }
        PortMapping portMapping = (PortMapping)status.getPorts().get(port);
        if (portMapping == null) {
            return null;
        }
        return portMapping.getExternalPort();
    }

    public HostAndPort address(String port) {
        List<HostAndPort> addresses = this.addresses(port);
        if (addresses.size() > 1) {
            throw new AssertionError((Object)"Job has been deployed to multiple hosts, use addresses method instead");
        }
        return addresses.get(0);
    }

    public List<HostAndPort> addresses(String port) {
        Preconditions.checkArgument((boolean)this.job.getPorts().containsKey(port), (String)"port %s not found", (Object[])new Object[]{port});
        ArrayList addresses = Lists.newArrayList();
        for (Map.Entry<String, TaskStatus> entry : this.statuses.entrySet()) {
            Integer externalPort = ((PortMapping)entry.getValue().getPorts().get(port)).getExternalPort();
            assert (externalPort != null);
            String host = this.endpointFromHost(entry.getKey());
            addresses.add(HostAndPort.fromParts((String)host, (int)externalPort));
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deploy() {
        TemporaryJobReports.Step createJob = this.reportWriter.step("create job").tag("jobId", this.job.getId());
        try {
            log.info("Creating job {}", (Object)this.job.getId().toShortString());
            CreateJobResponse createResponse = (CreateJobResponse)Jobs.get(this.client.createJob(this.job));
            if (createResponse.getStatus() != CreateJobResponse.Status.OK) {
                Assert.fail((String)String.format("Failed to create job %s - %s", this.job.getId(), createResponse.toString()));
            }
            createJob.markSuccess();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail((String)String.format("Failed to create job %s %s - %s", this.job.getId(), this.job.toString(), e));
        }
        finally {
            createJob.finish();
        }
        TemporaryJobReports.Step deployJob = this.reportWriter.step("deploy job").tag("jobId", this.job.getId());
        try {
            Deployment deployment = Deployment.of((JobId)this.job.getId(), (Goal)Goal.START);
            for (String host : this.hosts) {
                HostStatus hostStatus = (HostStatus)this.client.hostStatus(host).get();
                String hostAddress = (String)hostStatus.getEnvironment().get("HELIOS_HOST_ADDRESS");
                if (hostAddress != null) {
                    this.hostToIp.put(host, hostAddress);
                }
                log.info("Deploying {} to {}", (Object)Jobs.getJobDescription(this.job), (Object)host);
                JobDeployResponse deployResponse = (JobDeployResponse)Jobs.get(this.client.deploy(deployment, host));
                if (deployResponse.getStatus() == JobDeployResponse.Status.OK) continue;
                Assert.fail((String)String.format("Failed to deploy job %s %s - %s", this.job.getId(), this.job.toString(), deployResponse));
            }
            deployJob.markSuccess();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Assert.fail((String)String.format("Failed to deploy job %s %s - %s", this.job.getId(), this.job.toString(), e));
        }
        finally {
            deployJob.finish();
        }
        try {
            for (String host : this.hosts) {
                this.awaitUp(host);
            }
        }
        catch (TimeoutException e) {
            Assert.fail((String)String.format("Failed while probing job %s %s - %s", this.job.getId(), this.job.toString(), e));
        }
    }

    void undeploy(List<AssertionError> errors) {
        Jobs.undeploy(this.client, this.job, this.hosts, errors);
    }

    public void undeploy() {
        ArrayList errors = Lists.newArrayList();
        this.undeploy(errors);
        if (errors.size() > 0) {
            Assert.fail((String)String.format("Failed to undeploy job %s - %s", Jobs.getJobDescription(this.job), errors.get(0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitUp(final String host) throws TimeoutException {
        TemporaryJobReports.Step startContainer = this.reportWriter.step("start container").tag("jobId", this.job.getId()).tag("host", host).tag("image", this.job.getImage());
        try {
            final AtomicBoolean messagePrinted = new AtomicBoolean(false);
            TaskStatus status = Polling.awaitUnchecked(this.deployTimeoutMillis, TimeUnit.MILLISECONDS, new Callable<TaskStatus>(){

                @Override
                public TaskStatus call() throws Exception {
                    JobStatus status = (JobStatus)Futures.getUnchecked((Future)TemporaryJob.this.client.jobStatus(TemporaryJob.this.job.getId()));
                    if (status == null) {
                        log.debug("Job status not available");
                        return null;
                    }
                    TaskStatus taskStatus = (TaskStatus)status.getTaskStatuses().get(host);
                    if (taskStatus == null) {
                        log.debug("Task status not available on {}", (Object)host);
                        return null;
                    }
                    if (!(messagePrinted.get() || Strings.isNullOrEmpty((String)TemporaryJob.this.jobDeployedMessageFormat) || Strings.isNullOrEmpty((String)taskStatus.getContainerId()))) {
                        TemporaryJob.this.outputDeployedMessage(host, taskStatus.getContainerId());
                        messagePrinted.set(true);
                    }
                    TemporaryJob.this.verifyHealthy(host, taskStatus);
                    TaskStatus.State state = taskStatus.getState();
                    log.info("Job state of {}: {}", (Object)TemporaryJob.this.job.getImage(), (Object)state);
                    if (state == TaskStatus.State.RUNNING) {
                        return taskStatus;
                    }
                    return null;
                }
            });
            this.statuses.put(host, status);
            startContainer.markSuccess();
        }
        finally {
            startContainer.finish();
        }
        TemporaryJobReports.Step probe = this.reportWriter.step("probe").tag("jobId", this.job.getId()).tag("host", host);
        try {
            for (String port : this.waitPorts) {
                this.awaitPort(port, host);
            }
            probe.markSuccess();
        }
        finally {
            probe.finish();
        }
    }

    void verifyHealthy() throws AssertionError {
        log.debug("Checking health of {}", (Object)this.job.getImage());
        JobStatus status = (JobStatus)Futures.getUnchecked((Future)this.client.jobStatus(this.job.getId()));
        if (status == null) {
            return;
        }
        for (Map.Entry entry : status.getTaskStatuses().entrySet()) {
            this.verifyHealthy((String)entry.getKey(), (TaskStatus)entry.getValue());
        }
    }

    private void verifyHealthy(String host, TaskStatus status) {
        log.debug("Checking health of {} on {}", (Object)this.job.getImage(), (Object)host);
        TaskStatus.State state = status.getState();
        if (state == TaskStatus.State.FAILED || state == TaskStatus.State.EXITED || state == TaskStatus.State.STOPPED) {
            String stateString = state.toString();
            if (status.getThrottled() != ThrottleState.NO) {
                stateString = stateString + String.format("(%s)", status.getThrottled());
            }
            throw new AssertionError((Object)String.format("Unexpected job state %s for job %s with image %s on host %s. Check helios agent logs for details.", stateString, this.job.getId().toShortString(), this.job.getImage(), host));
        }
    }

    private void awaitPort(final String port, String host) throws TimeoutException {
        final String endpoint = this.endpointFromHost(host);
        TaskStatus taskStatus = this.statuses.get(host);
        assert (taskStatus != null);
        final Integer externalPort = ((PortMapping)taskStatus.getPorts().get(port)).getExternalPort();
        assert (externalPort != null);
        Polling.awaitUnchecked(Jobs.TIMEOUT_MILLIS, TimeUnit.MILLISECONDS, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                log.info("Probing: {} @ {}:{}", new Object[]{port, endpoint, externalPort});
                boolean up = TemporaryJob.this.prober.probe(endpoint, externalPort);
                if (up) {
                    log.info("Up: {} @ {}:{}", new Object[]{port, endpoint, externalPort});
                    return true;
                }
                return null;
            }
        });
    }

    private String endpointFromHost(String host) {
        String ip = this.hostToIp.get(host);
        return ip == null ? host : ip;
    }

    private void outputDeployedMessage(String host, String containerId) {
        StrSubstitutor subst = new StrSubstitutor((Map)new ImmutableMap.Builder().put((Object)"host", (Object)host).put((Object)"name", (Object)this.job.getId().getName()).put((Object)"version", (Object)this.job.getId().getVersion()).put((Object)"hash", (Object)this.job.getId().getHash()).put((Object)"job", (Object)this.job.toString()).put((Object)"containerId", (Object)containerId).build());
        log.info("{}", (Object)subst.replace(this.jobDeployedMessageFormat));
    }
}

