/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.Deployment;
import com.spotify.helios.common.descriptors.Goal;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.protocol.CreateJobResponse;
import com.spotify.helios.common.protocol.JobDeleteResponse;
import com.spotify.helios.common.protocol.JobDeployResponse;
import com.spotify.helios.common.protocol.JobUndeployResponse;
import com.spotify.helios.system.SystemTestBase;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZooKeeperNamespacingTest
extends SystemTestBase {
    private static final String NAMESPACE = "testing";

    @BeforeClass
    public static void setUpZkNamespace() {
        zooKeeperNamespace = NAMESPACE;
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster("--zk-namespace", NAMESPACE);
        this.startDefaultAgent(this.testHost(), "--zk-namespace", NAMESPACE);
        this.awaitHostRegistered(this.testHost(), 400L, TimeUnit.SECONDS);
        this.awaitHostStatus(this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        ExponentialBackoffRetry zooKeeperRetryPolicy = new ExponentialBackoffRetry(1000, 3);
        CuratorFramework framework = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)zooKeeperRetryPolicy).connectString(this.zk().connectString()).connectionTimeoutMs(30000).sessionTimeoutMs(30000).build();
        framework.start();
        List result = (List)framework.getChildren().forPath("/");
        Collections.sort(result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)NAMESPACE, result.get(0));
        Assert.assertEquals((Object)"zookeeper", result.get(1));
    }

    @Test
    public void testDeployment() throws Exception {
        this.startDefaultMaster("--zk-namespace", NAMESPACE);
        this.startDefaultAgent(this.testHost(), "--zk-namespace", NAMESPACE);
        HeliosClient client = this.defaultClient();
        Job job = Job.newBuilder().setName(this.testJobName).setVersion(this.testJobVersion).setImage("busybox:latest").setCommand(IDLE_COMMAND).setCreatingUser("test-user").build();
        JobId jobId = job.getId();
        CreateJobResponse created = (CreateJobResponse)client.createJob(job).get();
        Assert.assertEquals((Object)CreateJobResponse.Status.OK, (Object)created.getStatus());
        Deployment deployment = Deployment.of((JobId)jobId, (Goal)Goal.START, (String)"test-user");
        JobDeployResponse deployed = (JobDeployResponse)client.deploy(deployment, this.testHost()).get();
        Assert.assertEquals((Object)JobDeployResponse.Status.OK, (Object)deployed.getStatus());
        JobUndeployResponse undeployed = (JobUndeployResponse)client.undeploy(jobId, this.testHost()).get();
        Assert.assertEquals((Object)JobUndeployResponse.Status.OK, (Object)undeployed.getStatus());
        Deployment undeployedJob = (Deployment)client.deployment(this.testHost(), jobId).get();
        Assert.assertTrue((undeployedJob == null ? 1 : 0) != 0);
        this.awaitTaskGone(client, this.testHost(), jobId, 400L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)JobDeleteResponse.Status.OK, (Object)((JobDeleteResponse)client.deleteJob(jobId).get()).getStatus());
    }
}

