/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.spotify.helios.Parallelized;
import com.spotify.helios.ZooKeeperTestingClusterManager;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@Ignore(value="This is an expensive test that tests the curator framework, not helios. It is disabled as it likely gives travis grief")
@RunWith(value=Parallelized.class)
public class ZooKeeperCuratorFailoverTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    public static final byte[] FOO_DATA = "foo".getBytes();
    public static final String FOO = "/foo";
    private ZooKeeperTestingClusterManager zk;

    @Before
    public void setup() {
        this.zk = new ZooKeeperTestingClusterManager();
    }

    @After
    public void teardown() {
        this.zk.close();
    }

    @Test
    public void verifyCanCreateNodesWithOnePeerDead() throws Exception {
        this.zk.stopPeer(0);
        this.zk.stopPeer(1);
        this.zk.awaitDown(5, TimeUnit.MINUTES);
        this.zk.startPeer(1);
        this.zk.awaitUp(5L, TimeUnit.MINUTES);
        try {
            this.zk.curator().create().forPath(FOO, FOO_DATA);
            Assert.assertArrayEquals((byte[])FOO_DATA, (byte[])((byte[])this.zk.curator().getData().forPath(FOO)));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @Test
    public void verifyCanNotCreateNodesWithTwoPeersDead() throws Exception {
        this.zk.stopPeer(0);
        this.zk.stopPeer(1);
        this.zk.awaitDown(5, TimeUnit.MINUTES);
        this.expectedException.expect(KeeperException.ConnectionLossException.class);
        this.zk.curator().create().forPath(FOO, FOO_DATA);
    }

    @Test
    public void verifyZooKeeperRecoversWithTwoPeersAlive() throws Exception {
        this.zk.stopPeer(0);
        this.zk.stopPeer(1);
        this.zk.awaitDown(5, TimeUnit.MINUTES);
        this.zk.resetPeer(0);
        this.zk.startPeer(0);
        this.zk.awaitUp(5L, TimeUnit.MINUTES);
        try {
            this.zk.curator().create().forPath(FOO, FOO_DATA);
            Assert.assertArrayEquals((byte[])FOO_DATA, (byte[])((byte[])this.zk.curator().getData().forPath(FOO)));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @Test
    public void verifyZooKeeperToleratesOneNodeDataLoss() throws Exception {
        try {
            this.zk.curator().create().forPath(FOO, FOO_DATA);
            Assert.assertArrayEquals((byte[])FOO_DATA, (byte[])((byte[])this.zk.curator().getData().forPath(FOO)));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        this.zk.stopPeer(0);
        this.zk.resetPeer(0);
        this.zk.startPeer(0);
        this.zk.stopPeer(1);
        Assert.assertArrayEquals((byte[])FOO_DATA, (byte[])((byte[])this.zk.curator().getData().forPath(FOO)));
    }
}

