/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.system;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.spotify.helios.MockServiceRegistrarRegistry;
import com.spotify.helios.client.HeliosClient;
import com.spotify.helios.common.descriptors.HostStatus;
import com.spotify.helios.common.descriptors.Job;
import com.spotify.helios.common.descriptors.JobId;
import com.spotify.helios.common.descriptors.PortMapping;
import com.spotify.helios.common.descriptors.ServiceEndpoint;
import com.spotify.helios.common.descriptors.ServicePorts;
import com.spotify.helios.common.descriptors.TaskStatus;
import com.spotify.helios.serviceregistration.ServiceRegistrar;
import com.spotify.helios.serviceregistration.ServiceRegistration;
import com.spotify.helios.system.ServiceRegistrationTestBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class JobServiceRegistrationTest
extends ServiceRegistrationTestBase {
    private final int externalPort;
    @Mock
    public ServiceRegistrar registrar;
    @Captor
    public ArgumentCaptor<ServiceRegistration> registrationCaptor;
    final String registryAddress;

    public JobServiceRegistrationTest() {
        this.externalPort = this.temporaryPorts.localPort("external");
        this.registryAddress = this.uniqueRegistryAddress();
    }

    @Before
    public void setup() {
        MockServiceRegistrarRegistry.set((String)this.registryAddress, (ServiceRegistrar)this.registrar);
    }

    @After
    public void teardown() {
        MockServiceRegistrarRegistry.remove((String)this.registryAddress);
    }

    @Test
    public void test() throws Exception {
        this.startDefaultMaster(new String[0]);
        HeliosClient client = this.defaultClient();
        this.startDefaultAgent(this.testHost(), "--service-registry=" + this.registryAddress);
        this.awaitHostStatus(client, this.testHost(), HostStatus.Status.UP, 400, TimeUnit.SECONDS);
        ImmutableMap portMapping = ImmutableMap.of((Object)"foo_port", (Object)PortMapping.of((int)4711, (Integer)this.externalPort), (Object)"bar_port", (Object)PortMapping.of((int)4712));
        ImmutableMap registration = ImmutableMap.of((Object)ServiceEndpoint.of((String)"foo_service", (String)"foo_proto"), (Object)ServicePorts.of((String[])new String[]{"foo_port"}), (Object)ServiceEndpoint.of((String)"bar_service", (String)"bar_proto"), (Object)ServicePorts.of((String[])new String[]{"bar_port"}));
        JobId jobId = this.createJob(this.testJobName, this.testJobVersion, "busybox:latest", IDLE_COMMAND, Job.EMPTY_ENV, (Map<String, PortMapping>)portMapping, (Map<ServiceEndpoint, ServicePorts>)registration);
        this.deployJob(jobId, this.testHost());
        this.awaitJobState(client, this.testHost(), jobId, TaskStatus.State.RUNNING, 400, TimeUnit.SECONDS);
        ((ServiceRegistrar)Mockito.verify((Object)this.registrar, (VerificationMode)Mockito.timeout((int)((int)TimeUnit.SECONDS.toMillis(400L))))).register((ServiceRegistration)this.registrationCaptor.capture());
        ServiceRegistration serviceRegistration = (ServiceRegistration)this.registrationCaptor.getValue();
        HashMap registered = Maps.newHashMap();
        for (ServiceRegistration.Endpoint endpoint : serviceRegistration.getEndpoints()) {
            registered.put(endpoint.getName(), endpoint);
        }
        Assert.assertEquals((String)"wrong service", (Object)"foo_service", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"foo_proto", (Object)((ServiceRegistration.Endpoint)registered.get("foo_service")).getProtocol());
        Assert.assertEquals((String)"wrong port", (long)this.externalPort, (long)((ServiceRegistration.Endpoint)registered.get("foo_service")).getPort());
        Assert.assertEquals((String)"wrong service", (Object)"bar_service", (Object)((ServiceRegistration.Endpoint)registered.get("bar_service")).getName());
        Assert.assertEquals((String)"wrong protocol", (Object)"bar_proto", (Object)((ServiceRegistration.Endpoint)registered.get("bar_service")).getProtocol());
        Assert.assertNotEquals((String)"wrong port", (long)this.externalPort, (long)((ServiceRegistration.Endpoint)registered.get("bar_service")).getPort());
    }
}

