/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common.descriptors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.spotify.helios.common.descriptors.DeploymentGroupStatus;
import com.spotify.helios.common.descriptors.Descriptor;
import com.spotify.helios.common.descriptors.RolloutTask;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DeploymentGroupEvent
extends Descriptor {
    public static final String KAFKA_TOPIC = "HeliosDeploymentGroupEvents";
    private final RolloutTask.Action action;
    private final String target;
    private final RolloutTask.Status rolloutTaskStatus;
    private final DeploymentGroupStatus deploymentGroupStatus;
    private final long timestamp;

    public DeploymentGroupEvent(@JsonProperty(value="action") RolloutTask.Action action, @JsonProperty(value="target") String target, @JsonProperty(value="rolloutTaskStatus") RolloutTask.Status rolloutTaskStatus, @JsonProperty(value="deploymentGroupStatus") DeploymentGroupStatus deploymentGroupStatus, @JsonProperty(value="timestamp") long timestamp) {
        this.action = action;
        this.target = target;
        this.rolloutTaskStatus = rolloutTaskStatus;
        this.deploymentGroupStatus = deploymentGroupStatus;
        this.timestamp = timestamp;
    }

    private DeploymentGroupEvent(Builder builder) {
        this.deploymentGroupStatus = (DeploymentGroupStatus)Preconditions.checkNotNull((Object)builder.deploymentGroupStatus);
        this.action = builder.action;
        this.target = builder.target;
        this.rolloutTaskStatus = builder.rolloutTaskStatus;
        this.timestamp = builder.timestamp != null ? builder.timestamp : System.currentTimeMillis();
    }

    public RolloutTask.Action getAction() {
        return this.action;
    }

    public String getTarget() {
        return this.target;
    }

    public RolloutTask.Status getRolloutTaskStatus() {
        return this.rolloutTaskStatus;
    }

    public DeploymentGroupStatus getDeploymentGroupStatus() {
        return this.deploymentGroupStatus;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return Objects.toStringHelper(DeploymentGroupEvent.class).add("action", (Object)this.action).add("target", (Object)this.target).add("rolloutTaskStatus", (Object)this.rolloutTaskStatus).add("deploymentGroupStatus", (Object)this.deploymentGroupStatus).add("timestamp", this.timestamp).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentGroupEvent that = (DeploymentGroupEvent)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.action != that.action) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.rolloutTaskStatus != that.rolloutTaskStatus) {
            return false;
        }
        return !(this.deploymentGroupStatus != null ? !this.deploymentGroupStatus.equals(that.deploymentGroupStatus) : that.deploymentGroupStatus != null);
    }

    public int hashCode() {
        int result = this.action != null ? this.action.hashCode() : 0;
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.rolloutTaskStatus != null ? this.rolloutTaskStatus.hashCode() : 0);
        result = 31 * result + (this.deploymentGroupStatus != null ? this.deploymentGroupStatus.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public static class Builder {
        private RolloutTask.Action action;
        private String target;
        private RolloutTask.Status rolloutTaskStatus;
        private DeploymentGroupStatus deploymentGroupStatus;
        private Long timestamp;

        public Builder setAction(RolloutTask.Action action) {
            this.action = action;
            return this;
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setRolloutTaskStatus(RolloutTask.Status rolloutTaskStatus) {
            this.rolloutTaskStatus = rolloutTaskStatus;
            return this;
        }

        public Builder setDeploymentGroupStatus(DeploymentGroupStatus deploymentGroupStatus) {
            this.deploymentGroupStatus = deploymentGroupStatus;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public DeploymentGroupEvent build() {
            return new DeploymentGroupEvent(this);
        }
    }
}

