/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.helios.common;

import com.spotify.helios.common.PomVersion;

public class VersionCompatibility {
    public static final String HELIOS_VERSION_HEADER = "Helios-Version";
    public static final String HELIOS_SERVER_VERSION_HEADER = "Helios-Server-Version";
    public static final String HELIOS_VERSION_STATUS_HEADER = "Helios-Version-Status";

    public static Status getStatus(PomVersion serverVersion, PomVersion clientVersion) {
        if (serverVersion.equals(clientVersion)) {
            return Status.EQUAL;
        }
        if (serverVersion.getMajor() != clientVersion.getMajor()) {
            return Status.INCOMPATIBLE;
        }
        if (serverVersion.getMinor() >= clientVersion.getMinor()) {
            return Status.COMPATIBLE;
        }
        return Status.MAYBE;
    }

    public static enum Status {
        EQUAL,
        COMPATIBLE,
        MAYBE,
        INCOMPATIBLE,
        INVALID,
        MISSING;

    }
}

