/*
 * Decompiled with CFR 0.152.
 */
package at.mjst.lib.java.geometry.entities;

import at.mjst.lib.java.math.Random;
import java.util.Arrays;

public class KdPoint {
    private final int dimensionCount;
    private int[] offsets;

    public KdPoint(int dimensionCount) {
        if (dimensionCount <= 0) {
            throw new IllegalArgumentException("dimension-count > 0 required");
        }
        this.dimensionCount = dimensionCount;
        this.offsets = this.generateNewOffsetArray();
    }

    public KdPoint(int[] offsets) {
        this(offsets.length);
        System.arraycopy(offsets, 0, this.offsets, 0, this.dimensionCount);
    }

    public KdPoint(KdPoint point) {
        this(point.getDimensionCount());
        this.assign(point);
    }

    private int[] generateNewOffsetArray() {
        return new int[this.dimensionCount];
    }

    private void validateDimension(int dimension) {
        if (dimension < 0 || dimension > this.dimensionCount - 1) {
            throw new IndexOutOfBoundsException(String.format("axis %d out of bounds", dimension));
        }
    }

    public void assign(KdPoint point) {
        if (this.getDimensionCount() != point.getDimensionCount()) {
            throw new IllegalArgumentException(String.format("%d-dimensional point required", this.getDimensionCount()));
        }
        this.offsets = point.getOffsets();
    }

    private int[] getOffsets() {
        int[] copiedOffsets = this.generateNewOffsetArray();
        System.arraycopy(this.offsets, 0, copiedOffsets, 0, this.getDimensionCount());
        return copiedOffsets;
    }

    public int get(int axis) {
        this.validateDimension(axis);
        return this.offsets[axis];
    }

    public void set(int axis, int offset) {
        this.validateDimension(axis);
        this.offsets[axis] = offset;
    }

    public void setRandom(int origin, int bound) {
        for (int i = 0; i < this.offsets.length; ++i) {
            this.set(i, Random.randInt(origin, bound));
        }
    }

    public int getDimensionCount() {
        return this.dimensionCount;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof KdPoint && this.dimensionCount == ((KdPoint)obj).getDimensionCount() && Arrays.equals(this.offsets, ((KdPoint)obj).getOffsets());
    }

    public int hashCode() {
        return Arrays.hashCode(this.offsets);
    }

    public String toString() {
        return Arrays.toString(this.offsets);
    }

    public static class As3D
    extends KdPoint {
        As3D() {
            super(3);
        }
    }

    public static class As2D
    extends KdPoint {
        As2D() {
            super(2);
        }
    }
}

