/*
 * Decompiled with CFR 0.152.
 */
package at.mjst.lib.java.geometry.collections;

import at.mjst.lib.java.geometry.collections.KdMap;
import at.mjst.lib.java.geometry.entities.KdPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HashTreeKdMap<DataType>
implements KdMap<DataType> {
    private int dimensionCount;
    private Node root;
    private List<Container> index;

    public HashTreeKdMap(int dimensionCount) {
        if (dimensionCount <= 0) {
            throw new IllegalArgumentException("dimension-count > 0 required");
        }
        this.dimensionCount = dimensionCount;
        this.clear();
    }

    @Override
    public int getSize() {
        return this.index.size();
    }

    private Node locateNode(KdPoint key, boolean doCreate) {
        if (key.getDimensionCount() != this.dimensionCount) {
            throw new IllegalArgumentException(String.format("dimension count must be %d", this.dimensionCount));
        }
        Node currentNode = this.root;
        int axis = 0;
        do {
            if ((currentNode = currentNode.getSubNode(key.get(axis), doCreate)) != null) continue;
            return null;
        } while (++axis < this.dimensionCount);
        return currentNode;
    }

    @Override
    public void add(KdPoint key, DataType data) {
        Node node = this.locateNode(key, true);
        if (node != null) {
            if (node.hasLeaf()) {
                throw new RuntimeException("data already set for this key");
            }
        } else {
            throw new RuntimeException("error building node-tree");
        }
        node.setLeaf(new Container(data));
        this.index.add(node.getLeaf());
    }

    @Override
    public boolean containsKey(KdPoint key) {
        return this.locateNode(key, false) != null;
    }

    @Override
    public DataType get(KdPoint key) {
        Node node = this.locateNode(key, false);
        if (node != null) {
            if (node.hasLeaf()) {
                return node.getLeaf().getData();
            }
            throw new RuntimeException("leaf not found");
        }
        return null;
    }

    @Override
    public void clear() {
        this.root = new Node();
        this.index = new ArrayList<Container>();
    }

    @Override
    public Iterator<DataType> iterator() {
        return new MapIterator();
    }

    private class MapIterator
    implements Iterator<DataType> {
        private int current = 0;

        private MapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < HashTreeKdMap.this.index.size();
        }

        @Override
        public DataType next() {
            ++this.current;
            return ((Container)HashTreeKdMap.this.index.get(this.current - 1)).getData();
        }
    }

    private class Container {
        private DataType data;

        Container(DataType data) {
            this.setData(data);
        }

        DataType getData() {
            return this.data;
        }

        void setData(DataType data) {
            this.data = data;
        }
    }

    private class Node {
        private Map<Integer, Node> map;
        private Container leaf;

        private Node() {
        }

        Node getSubNode(int offset, boolean doCreate) {
            if (this.map == null) {
                if (!doCreate) {
                    return null;
                }
                this.map = new HashMap<Integer, Node>();
            }
            if (this.map.containsKey(offset)) {
                return this.map.get(offset);
            }
            if (doCreate) {
                Node node = new Node();
                this.map.put(offset, node);
                return node;
            }
            return null;
        }

        boolean hasLeaf() {
            return this.leaf != null;
        }

        Container getLeaf() {
            return this.leaf;
        }

        void setLeaf(Container container) {
            this.leaf = container;
        }
    }
}

