/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.core.util.Classes;
import at.ipsquare.commons.core.util.PerformanceLogFormatter;
import at.ipsquare.commons.core.util.PerformanceLogger;
import at.ipsquare.commons.servlet.DefaultPerformanceLogFilterMessageFormatter;
import at.ipsquare.commons.servlet.PathPatternRequestMatcher;
import at.ipsquare.commons.servlet.PerformanceLogFilterMessageFormatter;
import at.ipsquare.commons.servlet.RequestMatcher;
import at.ipsquare.commons.servlet.ServletConfigurationError;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceLogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PerformanceLogFilter.class);
    private static final PerformanceLogFilterMessageFormatter DEFAULT_LOG_FILTER_MESSAGE_FORMATTER = new DefaultPerformanceLogFilterMessageFormatter();
    public static final String INIT_PARAM_THRESHOLD = "threshold";
    public static final String INIT_PARAM_PREFIX = "prefix";
    public static final String INIT_PARAM_PERFORMANCE_LOG_FORMATTER = "performanceLogFormatter";
    public static final String INIT_PARAM_PERFORMANCE_LOG_FILTER_MESSAGE_FORMATTER = "performanceLogFilterMessageFormatter";
    private long threshold;
    private RequestMatcher requestMatcher;
    private String prefix;
    private Class<? extends PerformanceLogFormatter> logFormatterClass;
    private Class<? extends PerformanceLogFilterMessageFormatter> logFilterMessageFormatterClass;

    public void init(FilterConfig filterConfig) throws ServletException {
        String thresholdString = filterConfig.getInitParameter(INIT_PARAM_THRESHOLD);
        if (thresholdString != null) {
            try {
                this.threshold = Long.parseLong(thresholdString);
            }
            catch (NumberFormatException e) {
                throw new ServletConfigurationError("Not a legal value for threshold: '" + thresholdString + "'", e);
            }
        }
        this.requestMatcher = PathPatternRequestMatcher.fromFilterConfig(filterConfig);
        this.prefix = StringUtils.defaultString((String)filterConfig.getInitParameter(INIT_PARAM_PREFIX));
        this.logFormatterClass = PerformanceLogFilter.logFormatterClassFromConfig(filterConfig);
        this.logFilterMessageFormatterClass = this.logFilterMessageFormatterClassFromConfig(filterConfig);
    }

    private Class<? extends PerformanceLogFilterMessageFormatter> logFilterMessageFormatterClassFromConfig(FilterConfig filterConfig) {
        return PerformanceLogFilter.typeFromConfig(filterConfig, INIT_PARAM_PERFORMANCE_LOG_FILTER_MESSAGE_FORMATTER, PerformanceLogFilterMessageFormatter.class);
    }

    private static Class<? extends PerformanceLogFormatter> logFormatterClassFromConfig(FilterConfig filterConfig) {
        return PerformanceLogFilter.typeFromConfig(filterConfig, INIT_PARAM_PERFORMANCE_LOG_FORMATTER, PerformanceLogFormatter.class);
    }

    private static <T> Class<? extends T> typeFromConfig(FilterConfig filterConfig, String parameterName, Class<T> type) {
        String className = filterConfig.getInitParameter(parameterName);
        if (StringUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        try {
            return Classes.forName((String)className, type);
        }
        catch (ClassCastException e) {
            throw new ServletConfigurationError(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new ServletConfigurationError("Cannot load formatter class '" + className + "'.");
        }
    }

    private PerformanceLogFormatter performanceLogFormatter() {
        if (this.logFormatterClass == null) {
            return DefaultLogFormatter.INSTANCE;
        }
        try {
            return this.logFormatterClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not create an instance of " + this.logFormatterClass.getName() + ".", (Throwable)e);
            return DefaultLogFormatter.INSTANCE;
        }
    }

    private PerformanceLogFilterMessageFormatter filterMessageFormatter() {
        if (this.logFilterMessageFormatterClass == null) {
            return DEFAULT_LOG_FILTER_MESSAGE_FORMATTER;
        }
        try {
            return this.logFilterMessageFormatterClass.newInstance();
        }
        catch (Exception e) {
            log.error("Could not create an instance of " + this.logFilterMessageFormatterClass.getName() + ".", (Throwable)e);
            return DEFAULT_LOG_FILTER_MESSAGE_FORMATTER;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!this.requestMatcher.matches(req)) {
            chain.doFilter(req, res);
        } else {
            Throwable th = null;
            PerformanceLogger plog = new PerformanceLogger(this.threshold, this.performanceLogFormatter());
            try {
                chain.doFilter(req, res);
            }
            catch (Throwable e) {
                th = e;
            }
            finally {
                plog.logElapsed(this.toLogString(req, res, th));
            }
            if (th != null) {
                if (th instanceof IOException) {
                    throw (IOException)th;
                }
                if (th instanceof ServletException) {
                    throw (ServletException)th;
                }
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw new RuntimeException(th);
            }
        }
    }

    private String toLogString(ServletRequest req, ServletResponse res, Throwable th) {
        return this.prefix + this.filterMessageFormatter().format(req, res, th);
    }

    public void destroy() {
    }

    private static enum DefaultLogFormatter implements PerformanceLogFormatter
    {
        INSTANCE;


        public String format(StackTraceElement from, StackTraceElement to, long millis, String message) {
            return millis + "ms <<" + message + ">>";
        }
    }
}

