/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.core.interfaces.AbstractUnitOfWork;
import at.ipsquare.commons.core.interfaces.UnitOfWork;
import at.ipsquare.commons.core.util.Classes;
import at.ipsquare.commons.hibernate.HibernateRepository;
import at.ipsquare.commons.hibernate.HibernateRepositoryProvider;
import at.ipsquare.commons.servlet.PathPatternRequestMatcher;
import at.ipsquare.commons.servlet.RequestMatcher;
import at.ipsquare.commons.servlet.ServletConfigurationError;
import at.ipsquare.commons.servlet.TrivialRequestMatcher;
import java.io.IOException;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class HibernateUnitOfWorkFilter
implements Filter {
    private Map<String, HibernateRepository> repoMap;
    private RequestMatcher requestMatcher;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.requestMatcher.matches(req)) {
            HibernateUnitOfWorkFilter.recurseThroughRepos(this.repoMap != null ? this.repoMap.entrySet().iterator() : null, req, res, chain);
        } else {
            chain.doFilter(req, res);
        }
    }

    private static void recurseThroughRepos(final Iterator<Map.Entry<String, HibernateRepository>> iter, final ServletRequest req, final ServletResponse res, final FilterChain chain) throws IOException, ServletException {
        if (iter == null || !iter.hasNext()) {
            chain.doFilter(req, res);
            return;
        }
        Map.Entry<String, HibernateRepository> entry = iter.next();
        final String name = entry.getKey();
        HibernateRepository repo = entry.getValue();
        repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                HibernateUnitOfWorkFilter.recurseThroughRepos(iter, req, res, chain);
                return null;
            }

            public String getName() {
                return name;
            }
        });
    }

    public void init(FilterConfig cfg) throws ServletException {
        String includePattern = null;
        String excludePattern = null;
        LinkedHashMap<String, HibernateRepository> newRepoMap = new LinkedHashMap<String, HibernateRepository>();
        Enumeration paramNames = cfg.getInitParameterNames();
        if (paramNames != null) {
            while (paramNames.hasMoreElements()) {
                Object elem = paramNames.nextElement();
                if (elem == null) continue;
                String name = elem.toString();
                String value = cfg.getInitParameter(name);
                if ("includePathPattern".equals(name)) {
                    includePattern = value;
                    continue;
                }
                if ("excludePathPattern".equals(name)) {
                    excludePattern = value;
                    continue;
                }
                if (value == null) continue;
                HibernateRepository repo = HibernateUnitOfWorkFilter.loadHibernateRepository(value);
                newRepoMap.put(name, repo);
            }
        }
        this.requestMatcher = includePattern != null || excludePattern != null ? new PathPatternRequestMatcher(includePattern, excludePattern) : TrivialRequestMatcher.ANYTHING;
        HibernateUnitOfWorkFilter.checkForIdenticalRepos(newRepoMap);
        this.repoMap = newRepoMap;
    }

    private static void checkForIdenticalRepos(Map<String, HibernateRepository> repoMap) {
        IdentityHashMap<HibernateRepository, String> reverseRepoMap = new IdentityHashMap<HibernateRepository, String>();
        for (Map.Entry<String, HibernateRepository> entry : repoMap.entrySet()) {
            String oldKey = reverseRepoMap.put(entry.getValue(), entry.getKey());
            if (oldKey == null) continue;
            throw new ServletConfigurationError("Attempting to register the identical repositories ('" + entry.getValue() + "') with different names ('" + oldKey + "', '" + entry.getKey() + "').");
        }
    }

    private static HibernateRepositoryProvider loadProvider(String className) {
        Class<?> clazz = HibernateUnitOfWorkFilter.loadClass(className);
        if (!HibernateRepositoryProvider.class.isAssignableFrom(clazz)) {
            throw new ServletConfigurationError("'" + clazz.getCanonicalName() + "' does not implement '" + HibernateRepositoryProvider.class.getCanonicalName() + "'.");
        }
        try {
            HibernateRepositoryProvider provider = (HibernateRepositoryProvider)clazz.newInstance();
            return provider;
        }
        catch (InstantiationException e) {
            throw new ServletConfigurationError(HibernateUnitOfWorkFilter.unableToInstantineErrorString(clazz), e);
        }
        catch (IllegalAccessException e) {
            throw new ServletConfigurationError(HibernateUnitOfWorkFilter.unableToInstantineErrorString(clazz), e);
        }
    }

    private static HibernateRepository loadHibernateRepository(String providerClassName) {
        HibernateRepositoryProvider provider = HibernateUnitOfWorkFilter.loadProvider(providerClassName);
        HibernateRepository provided = provider.get();
        if (provided == null) {
            throw new ServletConfigurationError("Expected '" + provider.getClass().getCanonicalName() + ".get()' to return an instance of HibernateRepository but got null.");
        }
        return provided;
    }

    private static String unableToInstantineErrorString(Class<?> clazz) {
        return "Unable to instantine '" + clazz.getCanonicalName() + "'.";
    }

    private static Class<?> loadClass(String className) {
        try {
            return Classes.forName((String)className);
        }
        catch (ClassNotFoundException e1) {
            throw new ServletConfigurationError("Could not load class '" + className + "'.");
        }
    }
}

