/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.servlet.PerformanceLogFilterMessageFormatter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class DefaultPerformanceLogFilterMessageFormatter
implements PerformanceLogFilterMessageFormatter {
    @Override
    public String format(ServletRequest request, ServletResponse res, Throwable th) {
        if (!(request instanceof HttpServletRequest)) {
            return "" + request;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        StringBuilder sb = new StringBuilder().append(req.getMethod()).append(DefaultPerformanceLogFilterMessageFormatter.errorString(th)).append(" ");
        int lenWithMethodAndSpace = sb.length();
        if (req.getServletPath() != null) {
            sb.append(req.getServletPath());
        }
        if (req.getPathInfo() != null) {
            sb.append(req.getPathInfo());
        }
        if (StringUtils.isNotEmpty((CharSequence)req.getQueryString())) {
            sb.append("?").append(req.getQueryString());
        }
        if (sb.length() == lenWithMethodAndSpace) {
            sb.setLength(lenWithMethodAndSpace - 1);
        }
        return sb.toString();
    }

    private static String errorString(Throwable th) {
        if (th == null) {
            return "";
        }
        return "(!" + th.getClass().getSimpleName() + "!)";
    }
}

