/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.servlet.RequestEncodingFilter;
import at.ipsquare.commons.servlet.UnitTestFilterChain;
import at.ipsquare.commons.servlet.UnitTestFilterConfig;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.annotations.Test;

public class TestRequestEncodingFilter {
    @Test
    public void testDoFilter() throws ServletException, IOException {
        TestRequestEncodingFilter.testDoFilter(TestRequestEncodingFilter.filterConfig(), TestRequestEncodingFilter.reqCfg(null, null), "UTF-8");
        TestRequestEncodingFilter.testDoFilter(TestRequestEncodingFilter.filterConfig(), TestRequestEncodingFilter.reqCfg("US-ASCII", null), "US-ASCII");
        TestRequestEncodingFilter.testDoFilter(TestRequestEncodingFilter.filterConfig("UTF-8", true), TestRequestEncodingFilter.reqCfg("US-ASCII", null), "UTF-8");
        TestRequestEncodingFilter.testDoFilter(TestRequestEncodingFilter.filterConfig("UTF-8", false, ".*do$", ".*test.*"), TestRequestEncodingFilter.reqCfg(null, "mirkas.do"), "UTF-8");
        TestRequestEncodingFilter.testDoFilter(TestRequestEncodingFilter.filterConfig("UTF-8", true, ".*do$", ".*test.*"), TestRequestEncodingFilter.reqCfg(null, "test"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testDoFilter(EncodingFilterConfig filterConfig, ReqConfig reqResCfg, String exp) throws ServletException, IOException {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setCharacterEncoding(reqResCfg.reqEncoding);
        req.setServletPath(reqResCfg.path);
        RequestEncodingFilter filter = new RequestEncodingFilter();
        filter.init(TestRequestEncodingFilter.toServletFilterConfig(filterConfig));
        try {
            UnitTestFilterChain chain = new UnitTestFilterChain();
            filter.doFilter((ServletRequest)req, (ServletResponse)new MockHttpServletResponse(), (FilterChain)chain);
            Assert.assertTrue((boolean)chain.wasCalled());
            Assert.assertThat((Object)req.getCharacterEncoding(), (Matcher)Matchers.equalTo((Object)exp));
        }
        finally {
            filter.destroy();
        }
    }

    private static FilterConfig toServletFilterConfig(EncodingFilterConfig cfg) {
        if (cfg == null) {
            return new UnitTestFilterConfig();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("forceEncoding", "" + cfg.force);
        if (cfg.characterEncoding != null) {
            props.put("encoding", cfg.characterEncoding);
        }
        if (cfg.includePattern != null) {
            props.put("includePathPattern", cfg.includePattern);
        }
        if (cfg.excludePattern != null) {
            props.put("excludePathPattern", cfg.excludePattern);
        }
        return new UnitTestFilterConfig(props);
    }

    private static EncodingFilterConfig filterConfig() {
        return null;
    }

    private static EncodingFilterConfig filterConfig(String encoding, boolean force) {
        EncodingFilterConfig ret = new EncodingFilterConfig();
        ret.characterEncoding = encoding;
        ret.force = force;
        return ret;
    }

    private static EncodingFilterConfig filterConfig(String encoding, boolean force, String includePtn, String excludePtn) {
        EncodingFilterConfig ret = TestRequestEncodingFilter.filterConfig(encoding, force);
        ret.includePattern = includePtn;
        ret.excludePattern = excludePtn;
        return ret;
    }

    private static ReqConfig reqCfg(String reqEnc, String path) {
        ReqConfig ret = new ReqConfig();
        ret.reqEncoding = reqEnc;
        ret.path = path;
        return ret;
    }

    private static class ReqConfig {
        String reqEncoding;
        String path;

        private ReqConfig() {
        }
    }

    private static class EncodingFilterConfig {
        String characterEncoding;
        boolean force;
        String includePattern;
        String excludePattern;

        private EncodingFilterConfig() {
        }
    }
}

