/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.core.util.PerformanceLogFormatter;
import at.ipsquare.commons.servlet.DefaultPerformanceLogFilterMessageFormatter;
import at.ipsquare.commons.servlet.PerformanceLogFilter;
import at.ipsquare.commons.servlet.PerformanceLogFilterMessageFormatter;
import at.ipsquare.commons.servlet.UnitTestFilterChain;
import at.ipsquare.commons.servlet.UnitTestFilterConfig;
import ch.qos.logback.core.OutputStreamAppender;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jcip.annotations.Immutable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.annotations.Test;

public class TestPerformanceLogFilter {
    private static final Random rand = new Random();

    @Test
    public void testDoFilter() throws IOException, ServletException {
        String PREFIX = "!--";
        String[] IN_LOG = new String[]{"/in1.test", "in2=test", "/in/test/3", "here4.do", "~~preFix~~ ", "++**#prefix#**++", BrokenChainException.class.getSimpleName(), "!--"};
        String[] NOT_IN_LOG = new String[]{"/missing1.do", "/skip/this.do"};
        long THRESHOLD = 10L;
        UnitTestFilterChain chain = new SleepyChain(1L);
        PerformanceLogFilter filter = new PerformanceLogFilter();
        filter.init(new FilterConfigBuilder().toFilterConfig());
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req(null, null, null), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req(IN_LOG[0], null, null), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/hansi/hintenrum", null, IN_LOG[1]), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/foo", IN_LOG[2], ""), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter = new PerformanceLogFilter();
        filter.init(new FilterConfigBuilder().withThreshold(10L).withIncPtn("^.*do$").withExPtn(".*skip.*").toFilterConfig());
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req(NOT_IN_LOG[0], null, null), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        chain = new SleepyChain(11L);
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req(IN_LOG[3], null, "what=the&dj=hell"), null, (FilterChain)chain);
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/you/should", NOT_IN_LOG[1], "right=now"), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter = new PerformanceLogFilter();
        filter.init(new FilterConfigBuilder().whithThreshold(10L).withPrefex("!--").toFilterConfig());
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/whatever/you/want", "/is/already/here", "with=you"), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        filter = new PerformanceLogFilter();
        filter.init(new FilterConfigBuilder().withThreshold(0L).withPerformanceLogFormatter(LogMessageFormatter.class.getName()).toFilterConfig());
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/kirschen-essen", null, "nicht=gut"), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        try {
            chain = new BrokenCain();
            filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/ups", "/that/is/not/good", null), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        }
        catch (BrokenChainException e) {
            // empty catch block
        }
        chain = new SleepyChain(0L);
        filter = new PerformanceLogFilter();
        filter.init(new FilterConfigBuilder().withPerformanceLogFilterMessageFormatter(LogFilterMessageFormatter.class.getName()).toFilterConfig());
        filter.doFilter((ServletRequest)TestPerformanceLogFilter.req("/i/cant", null, "care=less"), (ServletResponse)TestPerformanceLogFilter.res(), (FilterChain)chain);
        String logString = TestAppender.stream.toString("UTF-8");
        for (String inLog : IN_LOG) {
            Assert.assertThat((Object)logString, (Matcher)Matchers.containsString((String)inLog));
        }
        for (String notInLog : NOT_IN_LOG) {
            Assert.assertThat((Object)logString, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)notInLog)));
        }
    }

    @Test
    public void testInitWithIllegalValues() throws ServletException {
        try {
            new PerformanceLogFilter().init(new FilterConfigBuilder().withThreshold(0L).withPerformanceLogFormatter("Uuuuups").toFilterConfig());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static HttpServletRequest req(String servletPath, String pathInfo, String queryString) {
        String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
        MockHttpServletRequest ret = new MockHttpServletRequest();
        ret.setMethod(HTTP_METHODS[rand.nextInt(HTTP_METHODS.length)]);
        ret.setServletPath(servletPath);
        ret.setPathInfo(pathInfo);
        ret.setQueryString(queryString);
        return ret;
    }

    private static HttpServletResponse res() {
        MockHttpServletResponse ret = new MockHttpServletResponse();
        return ret;
    }

    private static class FilterConfigBuilder {
        Long threshold;
        String incPtn;
        String exPtn;
        String prefix;
        String performanceLogFormatter;
        String performanceLogFilterMessageFormatter;

        private FilterConfigBuilder() {
        }

        FilterConfigBuilder whithThreshold(Long threshold) {
            this.threshold = threshold;
            return this;
        }

        FilterConfigBuilder withIncPtn(String incPtn) {
            this.incPtn = incPtn;
            return this;
        }

        FilterConfigBuilder withExPtn(String exPtn) {
            this.exPtn = exPtn;
            return this;
        }

        FilterConfigBuilder withPrefex(String prefix) {
            this.prefix = prefix;
            return this;
        }

        FilterConfigBuilder withPerformanceLogFormatter(String performanceLogFormatter) {
            this.performanceLogFormatter = performanceLogFormatter;
            return this;
        }

        FilterConfigBuilder withThreshold(Long threshold) {
            this.threshold = threshold;
            return this;
        }

        FilterConfigBuilder withPerformanceLogFilterMessageFormatter(String performanceLogFilterMessageFormatter) {
            this.performanceLogFilterMessageFormatter = performanceLogFilterMessageFormatter;
            return this;
        }

        FilterConfig toFilterConfig() {
            HashMap props = Maps.newHashMapWithExpectedSize((int)4);
            if (this.threshold != null) {
                props.put("threshold", "" + this.threshold);
            }
            if (this.incPtn != null) {
                props.put("includePathPattern", this.incPtn);
            }
            if (this.exPtn != null) {
                props.put("excludePathPattern", this.exPtn);
            }
            if (this.prefix != null) {
                props.put("prefix", this.prefix);
            }
            if (this.performanceLogFormatter != null) {
                props.put("performanceLogFormatter", this.performanceLogFormatter);
            }
            if (this.performanceLogFilterMessageFormatter != null) {
                props.put("performanceLogFilterMessageFormatter", this.performanceLogFilterMessageFormatter);
            }
            return new UnitTestFilterConfig(props);
        }
    }

    private static class BrokenCain
    extends UnitTestFilterChain {
        private BrokenCain() {
        }

        @Override
        protected void performDoFilter(ServletRequest req, ServletResponse res) {
            throw new BrokenChainException();
        }
    }

    private static class BrokenChainException
    extends RuntimeException {
        BrokenChainException() {
        }
    }

    private static class SleepyChain
    extends UnitTestFilterChain {
        final long millis;

        SleepyChain(long millis) {
            this.millis = millis;
        }

        @Override
        protected void performDoFilter(ServletRequest req, ServletResponse res) {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Immutable
    public static class LogFilterMessageFormatter
    implements PerformanceLogFilterMessageFormatter {
        private static final String PREFIX = "++**#prefix#**++";
        private static final PerformanceLogFilterMessageFormatter defaultFormatter = new DefaultPerformanceLogFilterMessageFormatter();

        public String format(ServletRequest req, ServletResponse res, Throwable th) {
            return PREFIX + defaultFormatter.format(req, res, th);
        }
    }

    @Immutable
    public static class LogMessageFormatter
    implements PerformanceLogFormatter {
        private static final String PREFIX = "~~preFix~~ ";

        public String format(StackTraceElement from, StackTraceElement to, long millis, String message) {
            return PREFIX + millis + "ms " + "<<" + message + ">>";
        }
    }

    public static class TestAppender<E>
    extends OutputStreamAppender<E> {
        private static final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        public void start() {
            this.setOutputStream(stream);
            super.start();
        }
    }
}

