/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.core.interfaces.ExecutionError;
import at.ipsquare.commons.core.interfaces.UnitOfWork;
import at.ipsquare.commons.hibernate.HibernateRepository;
import at.ipsquare.commons.hibernate.HibernateRepositoryProvider;
import at.ipsquare.commons.servlet.HibernateUnitOfWorkFilter;
import at.ipsquare.commons.servlet.ServletConfigurationError;
import at.ipsquare.commons.servlet.UnitTestFilterConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.hibernate.Session;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.annotations.Test;

public class TestHibernateUnitOfWorkFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilter() throws ServletException {
        HibernateUnitOfWorkFilter filter = new HibernateUnitOfWorkFilter();
        filter.init(TestHibernateUnitOfWorkFilter.validTestFilterConfig());
        try {
            TestHibernateUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainOk(), null);
            TestHibernateUnitOfWorkFilter.doFilter((Filter)filter, "/foo.jpg", new TestFilterChainOk(), null);
            TestHibernateUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainSevletException(), RuntimeException.class);
            TestHibernateUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainIoException(), RuntimeException.class);
            TestHibernateUnitOfWorkFilter.doFilter((Filter)filter, "/foo", new TestFilterChainRuntimeException(), RuntimeException.class);
        }
        finally {
            filter.destroy();
        }
        Assert.assertEquals((long)2L, (long)TestHibernateRepository.unitsProcessedOk.get());
        Assert.assertEquals((long)6L, (long)TestHibernateRepository.unitsProcessedError.get());
    }

    private static FilterConfig validTestFilterConfig() {
        return new UnitTestFilterConfig(TestHibernateUnitOfWorkFilter.validTestFilterConfigProperties());
    }

    private static Map<String, String> validTestFilterConfigProperties() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("repo1", TestRepositoryProvider1.class.getName());
        props.put("repo2", TestRepositoryProvider2.class.getName());
        props.put("includePathPattern", ".*");
        props.put("excludePathPattern", ".*\\.jpg");
        return props;
    }

    @Test
    public void testInit() {
        Map<String, String> props = new HashMap<String, String>();
        TestHibernateUnitOfWorkFilter.testInit(props, null);
        props = TestHibernateUnitOfWorkFilter.validTestFilterConfigProperties();
        TestHibernateUnitOfWorkFilter.testInit(props, null);
        props.put("", "");
        TestHibernateUnitOfWorkFilter.testInit(props, RuntimeException.class);
        props.remove("");
        props.put("duplicate", TestRepositoryProvider1.class.getName());
        TestHibernateUnitOfWorkFilter.testInit(props, ServletConfigurationError.class);
    }

    private static void testInit(Map<String, String> properties, Class<? extends Throwable> expectedException) {
        try {
            HibernateUnitOfWorkFilter filter = new HibernateUnitOfWorkFilter();
            filter.init((FilterConfig)new UnitTestFilterConfig(properties));
            if (expectedException != null) {
                Assert.fail((String)"Exception expected.");
            }
        }
        catch (Throwable th) {
            TestHibernateUnitOfWorkFilter.expectException(th, expectedException);
        }
    }

    private static void doFilter(Filter filter, String path, FilterChain chain, Class<? extends Throwable> expectedException) {
        try {
            filter.doFilter(TestHibernateUnitOfWorkFilter.requestFromPath(path), null, chain);
            if (expectedException != null) {
                Assert.fail((String)"Exception expected.");
            }
        }
        catch (Throwable th) {
            TestHibernateUnitOfWorkFilter.expectException(th, expectedException);
        }
    }

    private static ServletRequest requestFromPath(String path) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setPathInfo(path);
        req.setServletPath("");
        return req;
    }

    private static void expectException(Throwable th, Class<? extends Throwable> expectedException) {
        if (expectedException == null) {
            throw new RuntimeException(th);
        }
        if (!expectedException.isInstance(th)) {
            Assert.fail((String)("Expected " + expectedException.getSimpleName() + " but got  :" + th));
        }
    }

    private static class TestFilterChainRuntimeException
    implements FilterChain {
        private TestFilterChainRuntimeException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new RuntimeException("Ups!");
        }
    }

    private static class TestFilterChainIoException
    implements FilterChain {
        private TestFilterChainIoException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new IOException("Ups!");
        }
    }

    private static class TestFilterChainSevletException
    implements FilterChain {
        private TestFilterChainSevletException() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            throw new ServletException("Ups!");
        }
    }

    private static class TestFilterChainOk
    implements FilterChain {
        private TestFilterChainOk() {
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
        }
    }

    public static class TestRepositoryProvider2
    implements HibernateRepositoryProvider {
        static final TestRepository2 repo = new TestHibernateRepository();

        public TestRepository2 get() {
            return repo;
        }
    }

    public static class TestRepositoryProvider1
    implements HibernateRepositoryProvider {
        static final TestRepository1 repo = new TestHibernateRepository();

        public TestRepository1 get() {
            return repo;
        }
    }

    private static class TestHibernateRepository
    implements TestRepository1,
    TestRepository2 {
        static final AtomicInteger unitsProcessedOk = new AtomicInteger();
        static final AtomicInteger unitsProcessedError = new AtomicInteger();

        private TestHibernateRepository() {
        }

        public Session currentSession() {
            return null;
        }

        public <T> T executeUnitOfWork(UnitOfWork<T> work) {
            T t;
            boolean ok = false;
            try {
                work.execute();
                ok = true;
                t = null;
                (ok ? unitsProcessedOk : unitsProcessedError).incrementAndGet();
            }
            catch (Exception e) {
                try {
                    throw new ExecutionError((Throwable)e);
                }
                catch (Throwable throwable) {
                    (ok ? unitsProcessedOk : unitsProcessedError).incrementAndGet();
                    throw throwable;
                }
            }
            return t;
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }
    }

    public static interface TestRepository2
    extends HibernateRepository {
    }

    public static interface TestRepository1
    extends HibernateRepository {
    }
}

