/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.servlet;

import at.ipsquare.commons.servlet.PathPatternRequestMatcher;
import at.ipsquare.commons.servlet.RequestMatcher;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockServletContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPathPatternRequestMatcher {
    @Test
    public void testWithTrivialMatcher() {
        TestPathPatternRequestMatcher.testMatcher(true, null, null, "/egs/javax.servlet", "/GetReqUrl.html");
        TestPathPatternRequestMatcher.testMatcher(true, null, null, "/egs/javax.servlet", "/GetReqUrl.html;c=123");
    }

    @Test
    public void testWithIncludeOnly() {
        TestPathPatternRequestMatcher.testMatcher(true, "/foo.*", null, "/foo", null);
        TestPathPatternRequestMatcher.testMatcher(false, "/foo.*", null, "", "/bar");
    }

    @Test
    public void testWithExcludeOnly() {
        TestPathPatternRequestMatcher.testMatcher(false, null, "/.*\\.(css|gif)", "/foo/bar/styles.css", null);
        TestPathPatternRequestMatcher.testMatcher(true, null, "/.*\\.(css|gif)", "/foo/bar", "/action.do");
    }

    @Test
    public void testWithExcludeAndInclude() {
        TestPathPatternRequestMatcher.testMatcher(true, "/foo/.*\\.do.*", ".*error.*", "/foo", "/test.do;q=3");
        TestPathPatternRequestMatcher.testMatcher(false, "/foo/.*\\.do.*", ".*error.*", "/foo/error", null);
    }

    private static void testMatcher(boolean expected, String inc, String exc, String servletPath, String pathInfo) {
        RequestMatcher[] matchers;
        for (RequestMatcher matcher : matchers = new RequestMatcher[]{new PathPatternRequestMatcher(inc, exc), PathPatternRequestMatcher.fromFilterConfig((FilterConfig)TestPathPatternRequestMatcher.filterConfig(inc, exc)), PathPatternRequestMatcher.fromFilterConfig((FilterConfig)TestPathPatternRequestMatcher.filterConfigWithContextParams(inc, exc))}) {
            TestPathPatternRequestMatcher.testMatcher(expected, matcher, servletPath, pathInfo);
            TestPathPatternRequestMatcher.testMatcher(expected, matcher, servletPath + StringUtils.defaultString((String)pathInfo), null);
            TestPathPatternRequestMatcher.testMatcher(expected, matcher, "", servletPath + StringUtils.defaultString((String)pathInfo));
        }
    }

    private static void testMatcher(boolean expected, RequestMatcher matcher, String servletPath, String pathInfo) {
        Assert.assertEquals((boolean)expected, (boolean)matcher.matches(TestPathPatternRequestMatcher.servletRequest(servletPath, pathInfo)));
    }

    private static ServletRequest servletRequest(String servletPath, String pathInfo) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setServletPath(servletPath);
        req.setPathInfo(pathInfo);
        return req;
    }

    private static FilterConfig filterConfig(String inc, String exc) {
        MockFilterConfig config = new MockFilterConfig();
        config.addInitParameter("includePathPattern", inc);
        config.addInitParameter("excludePathPattern", exc);
        return config;
    }

    private static FilterConfig filterConfigWithContextParams(String inc, String exc) {
        MockServletContext context = new MockServletContext();
        context.addInitParameter("includePathPattern", inc);
        context.addInitParameter("excludePathPattern", exc);
        return new MockFilterConfig((ServletContext)context);
    }
}

