/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.hibernate;

import at.ipsquare.commons.core.interfaces.ExecutionError;
import at.ipsquare.commons.core.interfaces.UnitOfWork;
import at.ipsquare.commons.hibernate.HibernateConfiguration;
import at.ipsquare.commons.hibernate.HibernateRepository;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.ref.WeakReference;
import java.sql.Driver;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ThreadSafe
public class DefaultHibernateRepository
implements HibernateRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultHibernateRepository.class);
    private static final Map<Class<? extends DefaultHibernateRepository>, WeakReference<? extends DefaultHibernateRepository>> instanceMap = Maps.newHashMapWithExpectedSize((int)2);
    private final SessionFactory sessionFactory;
    private final ThreadLocal<Session> currentSession = new ThreadLocal();
    private final ThreadLocal<UnitOfWork<?>> currentUnitOfWork = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public DefaultHibernateRepository(HibernateConfiguration hibernateCfg) {
        Map<Class<? extends DefaultHibernateRepository>, WeakReference<? extends DefaultHibernateRepository>> map = instanceMap;
        synchronized (map) {
            DefaultHibernateRepository other;
            WeakReference<? extends DefaultHibernateRepository> ref = instanceMap.get(this.getClass());
            if (ref != null && (other = (DefaultHibernateRepository)ref.get()) != null && !other.isClosed()) {
                throw new IllegalStateException("Attempting to create an instance of " + this.getClass().getSimpleName() + " while " + "another instance that has not yet been closed is still weakly reachable. " + "You are not meant to have more than one open repository for the same underlying DB resource. " + "Plese read the documentation and fix your code.");
            }
            instanceMap.put(this.getClass(), new WeakReference<DefaultHibernateRepository>(this));
        }
        this.sessionFactory = DefaultHibernateRepository.buildSessionFactory(hibernateCfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeUnitOfWork(UnitOfWork<T> work) {
        if (work == null) {
            throw new NullPointerException();
        }
        if (this.currentUnitOfWork.get() != null) {
            log.info("Executing " + work + " within already running " + this.currentUnitOfWork.get() + ".");
            try {
                return (T)work.execute();
            }
            catch (Exception e) {
                log.warn(DefaultHibernateRepository.exceptionLogMessage(work), (Throwable)e);
                throw new ExecutionError((Throwable)e);
            }
        }
        log.info("Executing " + work + ".");
        Session session = this.session();
        this.currentSession.set(session);
        this.currentUnitOfWork.set(work);
        session.beginTransaction();
        try {
            Object result = null;
            try {
                result = work.execute();
            }
            catch (Exception e) {
                log.warn(DefaultHibernateRepository.exceptionLogMessage(work), (Throwable)e);
                Transaction tx = DefaultHibernateRepository.getActiveTransaction(session);
                if (tx != null) {
                    tx.rollback();
                }
                throw new ExecutionError((Throwable)e);
            }
            Transaction tx = DefaultHibernateRepository.getActiveTransaction(session);
            if (tx != null) {
                tx.commit();
            }
            Object object = result;
            return (T)object;
        }
        finally {
            try {
                log.info("Closing " + work + ".");
                session.close();
            }
            finally {
                this.currentSession.set(null);
                this.currentUnitOfWork.set(null);
            }
        }
    }

    @Override
    public void close() {
        this.sessionFactory.close();
    }

    @Override
    public boolean isClosed() {
        return this.sessionFactory.isClosed();
    }

    private static String exceptionLogMessage(UnitOfWork<?> work) {
        return "Executing " + work + " resulted in an exception.";
    }

    private static Transaction getActiveTransaction(Session session) {
        Transaction tx = session.getTransaction();
        if (tx != null && tx.isActive()) {
            return tx;
        }
        return null;
    }

    @Override
    public Session currentSession() {
        if (this.currentUnitOfWork.get() == null) {
            throw new IllegalStateException("Attempting to access the current session without a UnitOfWork.");
        }
        if (this.currentSession.get() == null) {
            throw new AssertionError((Object)"Should be impossible.");
        }
        return this.currentSession.get();
    }

    private Session session() {
        if (this.currentSession.get() != null) {
            return this.currentSession.get();
        }
        return this.sessionFactory.openSession();
    }

    private static SessionFactory buildSessionFactory(HibernateConfiguration hibernateCfg) {
        Configuration nativeCfg = DefaultHibernateRepository.toNativeHibernateConfiguration(hibernateCfg);
        ServiceRegistryBuilder builder = new ServiceRegistryBuilder();
        builder.applySettings((Map)nativeCfg.getProperties());
        return nativeCfg.buildSessionFactory(builder.buildServiceRegistry());
    }

    private static Configuration toNativeHibernateConfiguration(HibernateConfiguration hibernateCfg) {
        Configuration cfg = new Configuration();
        for (Class<?> domainClass : hibernateCfg.getDomainClasses()) {
            cfg.addAnnotatedClass(domainClass);
        }
        cfg.setProperty("hibernate.connection.username", hibernateCfg.getDbUser());
        cfg.setProperty("hibernate.connection.password", hibernateCfg.getDbPass());
        cfg.setProperty("hibernate.connection.url", hibernateCfg.getDbConnectionUrl());
        cfg.setProperty("hibernate.connection.driver_class", hibernateCfg.getDbDriverClass().getCanonicalName());
        cfg.setProperty("hibernate.hbm2ddl.auto", hibernateCfg.getHbm2dllAuto().toString());
        if (hibernateCfg.getProperties() != null) {
            for (Map.Entry<String, String> entry : hibernateCfg.getProperties().entrySet()) {
                cfg.setProperty(entry.getKey(), entry.getValue());
            }
        }
        DefaultHibernateRepository.explicitlyInitializeDriverClass(hibernateCfg.getDbDriverClass());
        return cfg;
    }

    private static void explicitlyInitializeDriverClass(Class<? extends Driver> clazz) {
        try {
            Class.forName(clazz.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load database driver.", e);
        }
    }
}

