/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.hibernate;

import at.ipsquare.hibernate.AbstractUnitOfWork;
import at.ipsquare.hibernate.DefaultHibernateRepository;
import at.ipsquare.hibernate.ExecutionError;
import at.ipsquare.hibernate.HibernateConfiguration;
import at.ipsquare.hibernate.HibernateRepository;
import at.ipsquare.hibernate.UnitOfWork;
import at.ipsquare.hibernate.UnitTestEntityChild;
import at.ipsquare.hibernate.UnitTestEntityParent;
import at.ipsquare.hibernate.UnitTestHibernateConfiguration;
import junit.framework.Assert;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.testng.annotations.Test;

public class TestDefaultHibernateRepository {
    private final HibernateRepository repo = new DefaultHibernateRepository((HibernateConfiguration)new UnitTestHibernateConfiguration());

    @Test(invocationCount=1, threadPoolSize=4, timeOut=5000L)
    public void testExecuteDbOperations() {
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                UnitTestEntityParent parent = new UnitTestEntityParent(TestDefaultHibernateRepository.threadLocalName("parent"));
                UnitTestEntityChild child1 = new UnitTestEntityChild(TestDefaultHibernateRepository.threadLocalName("child"));
                child1.setParent(parent);
                UnitTestEntityChild child2 = new UnitTestEntityChild(TestDefaultHibernateRepository.threadLocalName("child2"));
                child2.setParent(parent);
                parent.getChildren().add(child1);
                parent.getChildren().add(child2);
                TestDefaultHibernateRepository.this.repo.currentSession().saveOrUpdate((Object)parent);
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                UnitTestEntityParent parent = TestDefaultHibernateRepository.this.parentWithName("parent");
                Assert.assertNotNull((Object)parent);
                Assert.assertNotNull(parent.getChildren());
                Assert.assertEquals((int)2, (int)parent.getChildren().size());
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                UnitTestEntityParent parent = new UnitTestEntityParent(TestDefaultHibernateRepository.threadLocalName("evil"));
                TestDefaultHibernateRepository.this.repo.currentSession().saveOrUpdate((Object)parent);
                TestDefaultHibernateRepository.this.repo.currentSession().getTransaction().rollback();
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                UnitTestEntityParent parent = TestDefaultHibernateRepository.this.parentWithName("evil");
                Assert.assertNull((Object)parent);
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                TestDefaultHibernateRepository.this.repo.currentSession().getTransaction().commit();
                TestDefaultHibernateRepository.this.repo.currentSession().beginTransaction();
                UnitTestEntityParent parent = new UnitTestEntityParent(TestDefaultHibernateRepository.threadLocalName("parent2"));
                TestDefaultHibernateRepository.this.repo.currentSession().saveOrUpdate((Object)parent);
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                Assert.assertNotNull((Object)TestDefaultHibernateRepository.this.parentWithName("parent2"));
                return null;
            }
        });
        this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

            public Void execute() throws Exception {
                return (Void)TestDefaultHibernateRepository.this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

                    public Void execute() throws Exception {
                        Assert.assertNotNull((Object)TestDefaultHibernateRepository.this.parentWithName("parent"));
                        return null;
                    }
                });
            }
        });
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testCurrentSessionWithoutUnitOfWork() {
        this.repo.currentSession();
    }

    @Test
    public void testExectuteExceptionPassThrough() {
        try {
            this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Void>(){

                public Void execute() throws Exception {
                    throw new Exception("Ups!");
                }
            });
            Assert.fail((String)"Exception expected!");
        }
        catch (ExecutionError e) {
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertEquals((String)"Ups!", (String)e.getCause().getMessage());
        }
    }

    private static String threadLocalName(String name) {
        return name + "_" + Thread.currentThread().getId();
    }

    @Test
    public void testExecuteReturnValuePassThrough() {
        Assert.assertEquals((Object)0, (Object)this.repo.executeUnitOfWork((UnitOfWork)new AbstractUnitOfWork<Integer>(){

            public Integer execute() throws Exception {
                return 0;
            }
        }));
    }

    private UnitTestEntityParent parentWithName(String name) {
        Criteria c = this.repo.currentSession().createCriteria(UnitTestEntityParent.class).add((Criterion)Restrictions.eq((String)"name", (Object)TestDefaultHibernateRepository.threadLocalName(name)));
        return (UnitTestEntityParent)c.uniqueResult();
    }
}

