/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import java.util.Arrays;

public final class StackTrace {
    public static StackTraceElement[] get() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        int first = StackTrace.firstElemBelowThisClass(elems);
        return Arrays.copyOfRange(elems, first, elems.length);
    }

    public static StackTraceElement firstElementBelowClass() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        int first = StackTrace.firstElemBelowThisClass(elems);
        Class<?> callerClass = StackTrace.associatedClass(elems[first]);
        for (int i = first + 1; i < elems.length; ++i) {
            StackTraceElement current = elems[i];
            if (callerClass.equals(StackTrace.associatedClass(current))) continue;
            return current;
        }
        return null;
    }

    private static int firstElemBelowThisClass(StackTraceElement[] elems) {
        int i;
        boolean seenThisClass = false;
        for (i = 0; i < elems.length; ++i) {
            StackTraceElement elem = elems[i];
            Class<?> clazz = StackTrace.associatedClass(elem);
            if (StackTrace.class.equals(clazz)) {
                seenThisClass = true;
                continue;
            }
            if (seenThisClass) break;
        }
        return i;
    }

    static Class<?> associatedClass(StackTraceElement elem) {
        try {
            return Class.forName(elem.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find class from StackTraceElement; trouble awaits.", e);
        }
    }

    private StackTrace() {
    }
}

