/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.Classes;
import at.ipsquare.commons.core.util.DefaultPerformanceLogFormatter;
import at.ipsquare.commons.core.util.LocalResources;
import at.ipsquare.commons.core.util.PerformanceLogFormatter;
import at.ipsquare.commons.core.util.StackTrace;
import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PerformanceLogger {
    public static final String DEFAULT_SETTINGS_PATH = "at/ipsquare/commons/core/util/performanceLogger.xml";
    public static final String DEFAULT_PERFORMANCE_LOG_FORMATTER_KEY = "defaultPerformanceLogFormatter";
    public static final String DEFAULT_THRESHOLD_KEY = "defaultThreshold";
    private static volatile DefaultSettings defaultSettings;
    private static final Logger log;
    private final Stopwatch stopwatch;
    private final long threshold;
    private final PerformanceLogFormatter logFormatter;
    private StackTraceElement from;

    static void reloadDefaults() {
        defaultSettings = PerformanceLogger.loadDefaultSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefaultSettings loadDefaultSettings() {
        Class logFormatterClass = null;
        long threshold = 0L;
        try {
            InputStream in = LocalResources.getStream(DEFAULT_SETTINGS_PATH);
            try {
                Properties props = new Properties();
                props.loadFromXML(in);
                String formatterName = props.getProperty(DEFAULT_PERFORMANCE_LOG_FORMATTER_KEY);
                logFormatterClass = PerformanceLogger.loadFormatterClass(formatterName);
                String thresholdString = props.getProperty(DEFAULT_THRESHOLD_KEY);
                if (StringUtils.isNotEmpty((CharSequence)thresholdString)) {
                    try {
                        threshold = Long.parseLong(thresholdString);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Not a legal default threshold value: '" + thresholdString + "'.", (Throwable)e);
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            log.warn("Error reading at/ipsquare/commons/core/util/performanceLogger.xml.", (Throwable)e);
        }
        if (logFormatterClass == null) {
            logFormatterClass = DefaultPerformanceLogFormatter.class;
        }
        return new DefaultSettings(logFormatterClass, threshold);
    }

    private static Class<? extends PerformanceLogFormatter> loadFormatterClass(String name) {
        Class<PerformanceLogFormatter> ret;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return DefaultPerformanceLogFormatter.class;
        }
        try {
            ret = Classes.forName(name, PerformanceLogFormatter.class);
        }
        catch (ClassCastException e) {
            log.warn(e.getMessage());
            ret = DefaultPerformanceLogFormatter.class;
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not load default performance log formatter '" + name + "'.");
            ret = DefaultPerformanceLogFormatter.class;
        }
        return ret;
    }

    public PerformanceLogger() {
        this(PerformanceLogger.defaultSettings.threshold);
    }

    public PerformanceLogger(long threshold) {
        this(threshold, PerformanceLogger.getLogFormatter(null));
    }

    public PerformanceLogger(PerformanceLogFormatter logFormatter) {
        this(PerformanceLogger.defaultSettings.threshold, logFormatter);
    }

    public PerformanceLogger(long threshold, PerformanceLogFormatter logFormatter) {
        this.threshold = threshold;
        this.logFormatter = PerformanceLogger.getLogFormatter(logFormatter);
        if (log.isDebugEnabled()) {
            this.from = StackTrace.firstElementBelowClass();
            this.stopwatch = Stopwatch.createStarted();
        } else {
            this.from = null;
            this.stopwatch = Stopwatch.createUnstarted();
        }
    }

    private static PerformanceLogFormatter getLogFormatter(PerformanceLogFormatter logFormatter) {
        if (logFormatter != null) {
            return logFormatter;
        }
        return PerformanceLogger.defaultPerformanceLogFormatter();
    }

    private static PerformanceLogFormatter defaultPerformanceLogFormatter() {
        Class<? extends PerformanceLogFormatter> clazz = PerformanceLogger.defaultSettings.formatterClass;
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            log.warn("Cannot create a new instance of " + clazz.getName() + ".", (Throwable)e);
            return new DefaultPerformanceLogFormatter();
        }
    }

    public void logElapsed() {
        this.logElapsed(null);
    }

    public void logElapsedAndRestart() {
        this.logElapsedAndRestart(null);
    }

    public void logElapsed(String msg) {
        if (!log.isDebugEnabled() || !this.stopwatch.isRunning()) {
            return;
        }
        long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (elapsed >= this.threshold) {
            StackTraceElement to = StackTrace.firstElementBelowClass();
            log.debug(this.logFormatter.format(this.from, to, elapsed, msg));
        }
    }

    public void logElapsedAndRestart(String msg) {
        this.logElapsed(msg);
        this.restart();
    }

    public void restart() {
        if (!log.isDebugEnabled()) {
            return;
        }
        this.from = StackTrace.firstElementBelowClass();
        this.stopwatch.reset().start();
    }

    public static <T> T timedExec(long threshold, String msg, Supplier<T> block) {
        PerformanceLogger plog = new PerformanceLogger(threshold);
        T res = block.get();
        plog.logElapsed(msg);
        return res;
    }

    public static <T> T timedExec(String msg, Supplier<T> block) {
        return PerformanceLogger.timedExec(PerformanceLogger.defaultSettings.threshold, msg, block);
    }

    public static <T> T timedExec(long threshold, Supplier<T> block) {
        return PerformanceLogger.timedExec(threshold, null, block);
    }

    public static <T> T timedExec(Supplier<T> block) {
        return PerformanceLogger.timedExec(PerformanceLogger.defaultSettings.threshold, null, block);
    }

    public static void timedExec(long threshold, String msg, Runnable block) {
        PerformanceLogger plog = new PerformanceLogger(threshold);
        block.run();
        plog.logElapsed(msg);
    }

    public static void timedExec(long threshold, Runnable block) {
        PerformanceLogger.timedExec(threshold, null, block);
    }

    public static void timedExec(String msg, Runnable block) {
        PerformanceLogger.timedExec(PerformanceLogger.defaultSettings.threshold, msg, block);
    }

    public static void timedExec(Runnable block) {
        PerformanceLogger.timedExec(null, block);
    }

    static {
        log = LoggerFactory.getLogger(PerformanceLogger.class);
        PerformanceLogger.reloadDefaults();
    }

    private static final class DefaultSettings {
        final Class<? extends PerformanceLogFormatter> formatterClass;
        final long threshold;

        DefaultSettings(Class<? extends PerformanceLogFormatter> formatterClass, long threshold) {
            this.formatterClass = formatterClass;
            this.threshold = threshold;
        }
    }
}

