/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.PerformanceLogFormatter;
import at.ipsquare.commons.core.util.StackTrace;
import java.util.ArrayDeque;
import net.jcip.annotations.Immutable;

@Immutable
public final class DefaultPerformanceLogFormatter
implements PerformanceLogFormatter {
    @Override
    public String format(StackTraceElement from, StackTraceElement to, long millis, String message) {
        StringBuilder sb = new StringBuilder().append(String.format("%6dms ", millis));
        if (from != null && to != null) {
            Class<?> toClass;
            Class<?> fromClass = StackTrace.associatedClass(from);
            if (fromClass.equals(toClass = StackTrace.associatedClass(to))) {
                sb.append(DefaultPerformanceLogFormatter.className(fromClass));
                if (from.getMethodName().equals(to.getMethodName())) {
                    sb.append(".").append(from.getMethodName()).append("[");
                    if (from.getLineNumber() == to.getLineNumber()) {
                        sb.append(DefaultPerformanceLogFormatter.lineNumberToString(to));
                    } else {
                        sb.append(DefaultPerformanceLogFormatter.lineNumberToString(from)).append("->").append(DefaultPerformanceLogFormatter.lineNumberToString(to));
                    }
                    sb.append("]");
                } else {
                    sb.append("[").append(from.getMethodName()).append(":").append(DefaultPerformanceLogFormatter.lineNumberToString(from)).append("->").append(to.getMethodName()).append(":").append(DefaultPerformanceLogFormatter.lineNumberToString(to)).append("]");
                }
            } else {
                sb.append("[").append(DefaultPerformanceLogFormatter.className(fromClass)).append(".").append(from.getMethodName()).append(":").append(DefaultPerformanceLogFormatter.lineNumberToString(from)).append("->").append(DefaultPerformanceLogFormatter.className(toClass)).append(".").append(to.getMethodName()).append(":").append(DefaultPerformanceLogFormatter.lineNumberToString(to)).append("]");
            }
        } else {
            sb.append("[");
            StackTraceElement[] fromTo = new StackTraceElement[]{from, to};
            for (int i = 0; i < 2; ++i) {
                StackTraceElement elem = fromTo[i];
                if (elem == null) {
                    sb.append("???");
                } else {
                    Class<?> elemClass = StackTrace.associatedClass(elem);
                    sb.append(DefaultPerformanceLogFormatter.className(elemClass)).append(".").append(from.getMethodName()).append(":").append(DefaultPerformanceLogFormatter.lineNumberToString(elem));
                }
                if (i != 0) continue;
                sb.append("->");
            }
            sb.append("]");
        }
        if (message != null) {
            sb.append(" <<").append(message).append(">>");
        }
        return sb.toString();
    }

    private static String className(Class<?> clazz) {
        Class<?> parent;
        ArrayDeque parents = new ArrayDeque(2);
        parents.add(clazz);
        while ((parent = ((Class)parents.getFirst()).getEnclosingClass()) != null) {
            parents.addFirst(parent);
        }
        StringBuilder sb = new StringBuilder();
        for (Class clazz2 : parents) {
            if (sb.length() > 0) {
                sb.append("$");
            }
            sb.append(clazz2.getSimpleName());
        }
        return sb.toString();
    }

    private static String lineNumberToString(StackTraceElement elem) {
        int ln = elem.getLineNumber();
        return ln > 0 ? String.valueOf(ln) : "?";
    }
}

