/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.ClassLoaders;
import java.util.Iterator;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TestClassLoaders {
    @Test
    public void testCrud() {
        TestClassLoaders.setContextClassLoader(null);
        Assert.assertTrue((boolean)ClassLoaders.registered().isEmpty());
        Assert.assertThat((Object)ClassLoaders.get().size(), (Matcher)Matchers.equalTo((Object)1));
        TestClassLoaders.setContextClassLoader(new TestClassLoader("context"));
        Assert.assertThat((Object)ClassLoaders.get().size(), (Matcher)Matchers.equalTo((Object)2));
        TestClassLoader loader1 = new TestClassLoader("1");
        TestClassLoader loader2 = new TestClassLoader("2");
        Assert.assertTrue((boolean)ClassLoaders.register((ClassLoader)loader1));
        Assert.assertTrue((boolean)ClassLoaders.register((ClassLoader)loader2));
        Assert.assertFalse((boolean)ClassLoaders.register((ClassLoader)loader2));
        Set loaders = ClassLoaders.get();
        Assert.assertThat((Object)loaders.size(), (Matcher)Matchers.equalTo((Object)4));
        Iterator iter = loaders.iterator();
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)loader1));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)loader2));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)ClassLoaders.class.getClassLoader()));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)TestClassLoaders.getContextClassLoader()));
        Assert.assertTrue((boolean)ClassLoaders.unregister((ClassLoader)loader2));
        Assert.assertFalse((boolean)ClassLoaders.unregister((ClassLoader)loader2));
        Assert.assertThat((Object)ClassLoaders.get(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new ClassLoader[]{loader2})));
        Assert.assertTrue((boolean)ClassLoaders.register((ClassLoader)TestClassLoaders.getContextClassLoader()));
        loaders = ClassLoaders.get();
        Assert.assertThat((Object)loaders.size(), (Matcher)Matchers.equalTo((Object)3));
        iter = loaders.iterator();
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)loader1));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)TestClassLoaders.getContextClassLoader()));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)ClassLoaders.class.getClassLoader()));
        ClassLoaders.clear();
        Assert.assertTrue((boolean)ClassLoaders.registered().isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testRegisterWithNull() {
        ClassLoaders.register(null);
    }

    @Test(expected=NullPointerException.class)
    public void testUnregisterWithNull() {
        ClassLoaders.unregister(null);
    }

    private static void setContextClassLoader(ClassLoader loader) {
        Thread.currentThread().setContextClassLoader(loader);
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static class TestClassLoader
    extends ClassLoader {
        final String name;

        public TestClassLoader(String name) {
            super(TestClassLoader.class.getClassLoader());
            this.name = name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.name + "]";
        }
    }
}

