/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.commons.core.util;

import at.ipsquare.commons.core.util.StackTrace;
import com.google.common.base.Stopwatch;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PerformanceLogger {
    private static final Logger log = LoggerFactory.getLogger(PerformanceLogger.class);
    private final Stopwatch stopwatch;
    private final long threshold;
    private StackTraceElement from = StackTrace.firstElementBelowClass();

    public PerformanceLogger() {
        this(0L);
    }

    public PerformanceLogger(long threshold) {
        this.threshold = threshold;
        this.stopwatch = new Stopwatch().start();
    }

    public void logElapsed() {
        this.logElapsed(null);
    }

    public void logElapsedAndRestart() {
        this.logElapsedAndRestart(null);
    }

    public void logElapsed(String msg) {
        if (!log.isDebugEnabled()) {
            return;
        }
        long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (elapsed >= this.threshold) {
            StackTraceElement to = StackTrace.firstElementBelowClass();
            log.debug(PerformanceLogger.formatLogMessage(this.from, to, msg, elapsed));
        }
    }

    private static String formatLogMessage(StackTraceElement from, StackTraceElement to, String msg, long elapsed) {
        StringBuilder sb = new StringBuilder();
        if (from != null && to != null) {
            Class<?> toClass;
            Class<?> fromClass = StackTrace.associatedClass(from);
            if (fromClass.equals(toClass = StackTrace.associatedClass(to))) {
                sb.append(PerformanceLogger.className(fromClass));
                if (from.getMethodName().equals(to.getMethodName())) {
                    sb.append(".").append(from.getMethodName()).append("[").append(PerformanceLogger.lineNumberToString(from)).append("->").append(PerformanceLogger.lineNumberToString(to)).append("]");
                } else {
                    sb.append("[").append(from.getMethodName()).append(":").append(PerformanceLogger.lineNumberToString(from)).append("->").append(to.getMethodName()).append(":").append(PerformanceLogger.lineNumberToString(to)).append("]");
                }
            } else {
                sb.append("[").append(PerformanceLogger.className(fromClass)).append(".").append(from.getMethodName()).append(":").append(PerformanceLogger.lineNumberToString(from)).append("->").append(PerformanceLogger.className(toClass)).append(".").append(to.getMethodName()).append(":").append(PerformanceLogger.lineNumberToString(to)).append("]");
            }
        } else {
            sb.append("[");
            StackTraceElement[] fromTo = new StackTraceElement[]{from, to};
            for (int i = 0; i < 2; ++i) {
                StackTraceElement elem = fromTo[i];
                if (elem == null) {
                    sb.append("???");
                } else {
                    Class<?> elemClass = StackTrace.associatedClass(elem);
                    sb.append(PerformanceLogger.className(elemClass)).append(".").append(from.getMethodName()).append(":").append(PerformanceLogger.lineNumberToString(elem));
                }
                if (i != 0) continue;
                sb.append("->");
            }
            sb.append("]");
        }
        sb.append(" ").append(elapsed).append("ms");
        if (msg != null) {
            sb.append(" <<").append(msg).append(">>");
        }
        return sb.toString();
    }

    private static String className(Class<?> clazz) {
        Class<?> parent;
        ArrayDeque parents = new ArrayDeque(2);
        parents.add(clazz);
        while ((parent = ((Class)parents.getFirst()).getEnclosingClass()) != null) {
            parents.addFirst(parent);
        }
        StringBuilder sb = new StringBuilder();
        for (Class clazz2 : parents) {
            if (sb.length() > 0) {
                sb.append("$");
            }
            sb.append(clazz2.getSimpleName());
        }
        return sb.toString();
    }

    private static String lineNumberToString(StackTraceElement elem) {
        int ln = elem.getLineNumber();
        return ln > 0 ? String.valueOf(ln) : "?";
    }

    public void logElapsedAndRestart(String msg) {
        this.logElapsed(msg);
        this.restart();
    }

    public void restart() {
        if (!log.isDebugEnabled()) {
            return;
        }
        this.from = StackTrace.firstElementBelowClass();
        this.stopwatch.reset().start();
    }
}

