/*
 * Decompiled with CFR 0.152.
 */
package at.ipsquare.util;

import at.ipsquare.commons.core.util.LocalResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalResources {
    private static String TEST_FILE_PATH = "at/ipsquare/util/_LocalResources/test.txt";
    private static String NOT_EXISTING_PATH = "ASDFKJASDLFlsdfsdll/sdf/dd";
    private static String WITHIN_COMMONS_COLLECTIONS_JAR_PATH = "META-INF/maven/commons-collections/commons-collections/pom.properties";
    private static String STARTS_WITH_SLASH = "/META-INF/maven/commons-collections/commons-collections/pom.properties";

    @Test
    public void testGetFile() {
        TestLocalResources.testGetFile(TEST_FILE_PATH, "test", null);
        TestLocalResources.testGetFile(NOT_EXISTING_PATH, null, NOT_EXISTING_PATH);
        TestLocalResources.testGetFile(WITHIN_COMMONS_COLLECTIONS_JAR_PATH, null, "getStream");
        TestLocalResources.testGetFile(STARTS_WITH_SLASH, null, "leading");
    }

    @Test
    public void testGetUrl() throws IOException {
        URL url = LocalResources.getUrl((String)WITHIN_COMMONS_COLLECTIONS_JAR_PATH);
        Assert.assertNotNull((Object)url);
        String contents = TestLocalResources.consume(url.openStream());
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)contents, (CharSequence)"commons-collections"));
    }

    @Test
    public void testGetStream() throws IOException {
        InputStream in = LocalResources.getStream((String)TEST_FILE_PATH);
        Assert.assertNotNull((Object)in);
        String contents = TestLocalResources.consume(in);
        Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)contents, (CharSequence)"test"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetFile(String path, String expectedContents, String expectedError) {
        ClassLoader origContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            TestLocalResources.testGetFile(path, expectedContents, expectedError, origContextClassLoader);
            TestLocalResources.testGetFile(path, expectedContents, expectedError, null);
            TestLocalResources.testGetFile(path, expectedContents, expectedError, TestLocalResources.class.getClassLoader());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassLoader);
        }
    }

    private static void testGetFile(String path, String expectedContents, String expectedError, ClassLoader contextClassLoader) {
        try {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            File f = LocalResources.getFile((String)path);
            if (expectedError != null) {
                Assert.fail((String)("Expected an error containing '" + expectedError + "'."));
            }
            Assert.assertNotNull((Object)f);
            Assert.assertTrue((boolean)f.exists());
            Assert.assertTrue((boolean)f.canRead());
            String contents = TestLocalResources.consume(new FileInputStream(f));
            Assert.assertTrue((boolean)StringUtils.containsIgnoreCase((CharSequence)contents, (CharSequence)expectedContents));
        }
        catch (Throwable th) {
            if (expectedError == null) {
                Assert.fail((String)("Did not expect an error but got: " + th));
            }
            Assert.assertTrue((String)("Expected exception message containing '" + expectedError + "' but got:\n" + th.getMessage()), (boolean)StringUtils.containsIgnoreCase((CharSequence)th.getMessage(), (CharSequence)expectedError));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String consume(InputStream in) throws IOException {
        try {
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

