/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.lucre.matrix.gui.impl;

import de.sciss.lucre.matrix.DataSource;
import de.sciss.lucre.matrix.Matrix;
import de.sciss.lucre.matrix.gui.DimensionIndex;
import de.sciss.lucre.matrix.gui.impl.DimensionIndexImpl;
import de.sciss.lucre.matrix.gui.impl.DimensionIndexImpl$;
import de.sciss.lucre.matrix.gui.impl.DimensionIndexImpl$$anonfun$apply$1$;
import de.sciss.lucre.stm.Sys;
import de.sciss.lucre.stm.Txn;
import de.sciss.synth.proc.GenContext;
import java.io.IOException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

public final class DimensionIndexImpl$ {
    public static final DimensionIndexImpl$ MODULE$;

    static {
        new DimensionIndexImpl$();
    }

    public <S extends Sys<S>> DimensionIndex<S> apply(Matrix<S> dim, Txn tx, DataSource.Resolver<S> resolver, ExecutionContext exec, GenContext<S> context) {
        Boolean bl;
        if (dim.rank(tx) != 1) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Matrix must be 1-dimensional: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dim})));
        }
        int sz = (int)dim.size(tx);
        Matrix.ReaderFactory key = dim.prepareReader(0, tx);
        Promise p = Promise$.MODULE$.apply();
        float[] arr = new float[sz];
        Future fut = p.future();
        try {
            Future rFut = key.reader(tx, resolver, exec, context);
            tx.afterCommit((Function0)new Serializable(exec, sz, p, arr, rFut){
                public static final long serialVersionUID = 0L;
                private final ExecutionContext exec$1;
                public final int sz$1;
                private final Promise p$1;
                public final float[] arr$1;
                private final Future rFut$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Future fut1 = this.rFut$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.apply.1 $outer;

                        public final void apply(Matrix.Reader r) {
                            Predef$.MODULE$.assert(r.numChannels() == 1 && r.numFrames() == (long)this.$outer.sz$1);
                            package$.MODULE$.blocking((Function0)new Serializable(this, r){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$apply$1$$anonfun$1 $outer;
                                private final Matrix.Reader r$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    float[][] buf = (float[][])((Object[])new float[][]{this.$outer.de$sciss$lucre$matrix$gui$impl$DimensionIndexImpl$$anonfun$$anonfun$$$outer().arr$1});
                                    this.r$1.readFloat2D(buf, 0, this.$outer.de$sciss$lucre$matrix$gui$impl$DimensionIndexImpl$$anonfun$$anonfun$$$outer().sz$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.r$1 = r$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.apply.1 de$sciss$lucre$matrix$gui$impl$DimensionIndexImpl$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, this.exec$1);
                    this.p$1.completeWith(fut1);
                }
                {
                    this.exec$1 = exec$1;
                    this.sz$1 = sz$1;
                    this.p$1 = p$1;
                    this.arr$1 = arr$1;
                    this.rFut$1 = rFut$1;
                }
            });
            bl = BoxedUnit.UNIT;
        }
        catch (IOException iOException) {
            bl = BoxesRunTime.boxToBoolean((boolean)p.tryFailure((Throwable)iOException));
        }
        Function1<Object, String> unitsFun = this.unitsStringFormatter(dim.units(tx));
        DimensionIndexImpl.Impl res = new DimensionIndexImpl.Impl(arr, (Future<BoxedUnit>)fut, unitsFun);
        fut.foreach((Function1)new Serializable(res){
            public static final long serialVersionUID = 0L;
            public final DimensionIndexImpl.Impl res$1;

            public final void apply(BoxedUnit x$1) {
                de.sciss.lucre.swing.package$.MODULE$.defer((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.4 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.res$1.fireReady();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.res$1 = res$1;
            }
        }, exec);
        return res;
    }

    public boolean shouldUseUnitsString(String units) {
        return units.startsWith("days since") || units.startsWith("hours since") || units.startsWith("seconds since");
    }

    public String mkUnitsString(String units) {
        String string = units;
        String string2 = "degrees_north".equals(string) ? "\u00b0N" : ("degrees_east".equals(string) ? "\u00b0E" : ("kg m-2 s-1".equals(string) ? "kg/(m\u00b2s)" : ("W m-2".equals(string) ? "W/m\u00b2" : ("m s-1".equals(string) ? "m/s" : units))));
        return string2;
    }

    public Function1<Object, String> unitsStringFormatter(String units) {
        Object object;
        String string = units;
        if ("".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    double arg$macro$1 = d;
                    return new StringOps("%1.2f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
                }
            };
        } else if ("degrees_north".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    String string;
                    if (d >= 0.0) {
                        double arg$macro$2 = d;
                        string = new StringOps("%1.2f \u00b0N").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}));
                    } else {
                        double arg$macro$3 = -d;
                        string = new StringOps("%1.2f \u00b0S").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}));
                    }
                    return string;
                }
            };
        } else if ("degrees_east".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    String string;
                    if (d >= 0.0) {
                        double arg$macro$4 = d;
                        string = new StringOps("%1.2f \u00b0E").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4)}));
                    } else {
                        double arg$macro$5 = -d;
                        string = new StringOps("%1.2f \u00b0W").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$5)}));
                    }
                    return string;
                }
            };
        } else if ("(0 - 1)".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    double arg$macro$6 = d * (double)100;
                    return new StringOps("%1.1f%%").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$6)}));
                }
            };
        } else if ("kg m-2 s-1".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    double arg$macro$7 = d;
                    return new StringOps("%1.2f kg/(m\u00b2s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$7)}));
                }
            };
        } else if ("W m-2".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    double arg$macro$8 = d;
                    return new StringOps("%1.2f W/m\u00b2").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$8)}));
                }
            };
        } else if ("m s-1".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    double arg$macro$9 = d;
                    return new StringOps("%1.2f m/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$9)}));
                }
            };
        } else if ("Pa".equals(string)) {
            object = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(double d) {
                    int arg$macro$10 = (int)d;
                    return new StringOps("%d Pa").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$10)}));
                }
            };
        } else if (units.startsWith("days since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(11));
            object = new Serializable(date){
                public static final long serialVersionUID = 0L;
                private final CalendarDate date$1;

                public final String apply(double d) {
                    CalendarDate dt = this.date$1.add(d, CalendarPeriod.Field.Day);
                    return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
                }
                {
                    this.date$1 = date$1;
                }
            };
        } else if (units.startsWith("hours since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(12));
            object = new Serializable(date){
                public static final long serialVersionUID = 0L;
                private final CalendarDate date$2;

                public final String apply(double d) {
                    CalendarDate dt = this.date$2.add(d, CalendarPeriod.Field.Hour);
                    return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
                }
                {
                    this.date$2 = date$2;
                }
            };
        } else if (units.startsWith("seconds since")) {
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, (String)units.substring(14));
            object = new Serializable(date){
                public static final long serialVersionUID = 0L;
                private final CalendarDate date$3;

                public final String apply(double d) {
                    CalendarDate dt = this.date$3.add(d, CalendarPeriod.Field.Second);
                    return CalendarDateFormatter.toDateTimeString((CalendarDate)dt);
                }
                {
                    this.date$3 = date$3;
                }
            };
        } else {
            object = new Serializable(units){
                public static final long serialVersionUID = 0L;
                private final String units$1;

                public final String apply(double d) {
                    double arg$macro$11 = d;
                    String arg$macro$12 = this.units$1;
                    return new StringOps("%1.2f %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$11), arg$macro$12}));
                }
                {
                    this.units$1 = units$1;
                }
            };
        }
        return object;
    }

    private DimensionIndexImpl$() {
        MODULE$ = this;
    }
}

