/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.vaadin.ui.views;

import at.chrl.nutils.configuration.ConfigUtil;
import at.chrl.nutils.configuration.PropertiesUtils;
import at.chrl.vaadin.ui.BasicUIView;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

public class ConfigView
extends BasicUIView {
    private Table tbl = new Table("Active Configuration:");

    public ConfigView() {
        this.tbl.addContainerProperty((Object)"Id", String.class, (Object)"");
        this.tbl.addContainerProperty((Object)"Value", String.class, (Object)"");
        this.tbl.setSizeFull();
        this.tbl.setHeight(20.0f, Sizeable.Unit.CM);
        this.addComponent((Component)this.tbl);
        this.loadProperties();
        this.tbl.setSortEnabled(true);
    }

    private void loadProperties() {
        try {
            for (Properties properties : ConfigView.getActiveProperties()) {
                properties.entrySet().forEach(e -> this.tbl.addItem(new Object[]{e.getKey(), e.getValue()}, e.getKey()));
            }
        }
        catch (UnsupportedOperationException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private static Properties[] getActiveProperties() throws IOException {
        if (Objects.nonNull(ConfigUtil.getConfigDirectory())) {
            return PropertiesUtils.loadAllFromDirectory((File)ConfigUtil.getConfigDirectory(), (boolean)false);
        }
        return PropertiesUtils.loadAllFromDirectory((File)new File("."), (boolean)false);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.tbl.removeAllItems();
        this.loadProperties();
    }
}

