/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.controller;

import at.chrl.nutils.JVMInfoUtil;
import at.chrl.nutils.configuration.ConfigUtil;
import at.chrl.nutils.configuration.PropertiesUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BasicController {
    @RequestMapping(value={"exception"})
    public boolean throwException() {
        throw new RuntimeException("Test Exception thrown by request at " + new Date().toString());
    }

    @RequestMapping(value={"jvm"})
    public String getJVMInfo() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JVMInfoUtil.printAllInfos((PrintStream)new PrintStream(baos));
        return baos.toString().replace(System.lineSeparator(), "<br>");
    }

    @RequestMapping(value={"config"})
    public String getConfigs() throws IOException {
        return BasicController.prettyPrinted(BasicController.getActiveProperties());
    }

    @RequestMapping(value={"properties"})
    public Properties[] getProperties() throws IOException {
        return BasicController.getActiveProperties();
    }

    @RequestMapping(value={"property"})
    public Object getProperty(@RequestParam(value="id") String id) throws IOException {
        for (Properties properties : BasicController.getActiveProperties()) {
            Object object = properties.get(id);
            if (!Objects.nonNull(object)) continue;
            return object;
        }
        return null;
    }

    private static String prettyPrinted(Object json) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writer().withDefaultPrettyPrinter();
        return writer.writeValueAsString(json).replace(System.lineSeparator(), "<br>");
    }

    private static Properties[] getActiveProperties() throws IOException {
        if (Objects.nonNull(ConfigUtil.getConfigDirectory())) {
            return PropertiesUtils.loadAllFromDirectory((File)ConfigUtil.getConfigDirectory(), (boolean)false);
        }
        return PropertiesUtils.loadAllFromDirectory((File)new File("."), (boolean)false);
    }
}

