/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.config;

import at.chrl.spring.config.WebMvcConfig;
import at.chrl.vaadin.SpringUIProvider;
import at.chrl.vaadin.ui.BasicUI;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.web.context.ContextCleanupListener;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;
import ru.xpoft.vaadin.SpringVaadinServlet;

public abstract class AbstractWebAppInitializer
extends AbstractAnnotationConfigDispatcherServletInitializer {
    protected String[] getServletMappings() {
        return new String[]{"/"};
    }

    protected Class<?>[] getServletConfigClasses() {
        return new Class[]{WebMvcConfig.class};
    }

    protected abstract void registerOtherVaadinServlet(ServletContext var1);

    protected Filter[] getServletFilters() {
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setEncoding("UTF-8");
        characterEncodingFilter.setForceEncoding(true);
        return new Filter[]{characterEncodingFilter};
    }

    protected void customizeRegistration(ServletRegistration.Dynamic registration) {
        registration.setInitParameter("defaultHtmlEscape", "true");
        registration.setInitParameter("spring.profiles.active", "default");
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        rootContext.register(this.getRootConfigClasses());
        this.registerSpringContextLoaderListener(servletContext, (WebApplicationContext)rootContext);
        this.registerVaadinServlet(servletContext);
        this.registerDispatcherServlet(servletContext);
    }

    private void registerVaadinServlet(ServletContext servletContext) {
        SpringVaadinServlet vaadinServlet = new SpringVaadinServlet();
        ServletRegistration.Dynamic vaadinServletRegistration = servletContext.addServlet("vaadinServlet", (Servlet)vaadinServlet);
        vaadinServletRegistration.setInitParameter("ui", BasicUI.class.getName());
        vaadinServletRegistration.setInitParameter("UIProvider", SpringUIProvider.class.getName());
        vaadinServletRegistration.setLoadOnStartup(1);
        vaadinServletRegistration.addMapping(new String[]{"/ui/*"});
        vaadinServletRegistration.addMapping(new String[]{"/VAADIN/*"});
        this.registerOtherVaadinServlet(servletContext);
    }

    private void registerSpringContextLoaderListener(ServletContext servletContext, WebApplicationContext rootContext) {
        servletContext.addListener((EventListener)new ContextLoaderListener(rootContext));
        servletContext.addListener((EventListener)new ContextCleanupListener());
        servletContext.addListener((EventListener)new RequestContextListener());
    }
}

