/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.hibernate.config.impl;

import at.chrl.nutils.CollectionUtils;
import at.chrl.spring.generics.repositories.GenericIndexedRepository;
import at.chrl.spring.generics.repositories.GenericRepository;
import at.chrl.spring.generics.repositories.IndexSearcher;
import at.chrl.spring.generics.repositories.SpatialIndexSearcher;
import at.chrl.spring.hibernate.config.RepositoryHolder;
import at.chrl.spring.hibernate.config.SpringJpaConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Spatial;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class RepositoryHolderImplementation
implements RepositoryHolder,
ApplicationContextAware {
    private Map<Class<?>, GenericRepository<?>> repositories;
    private SpringJpaConfig jpaConfig;
    private Collection<GenericRepository<?>> autoWiredRepositories;
    private Map<Class<?>, Map<Class<?>, IndexSearcher<?>>> indexSearchers;

    public RepositoryHolderImplementation(SpringJpaConfig jpaConfig, Collection<GenericRepository<?>> autoWiredRepositories) {
        this.jpaConfig = jpaConfig;
        this.autoWiredRepositories = Objects.isNull(autoWiredRepositories) ? Collections.emptyList() : autoWiredRepositories;
    }

    private <T> GenericRepository<T> registerRepositoryBean(DefaultListableBeanFactory registry, Class<T> genericType) {
        boolean indexed = Objects.nonNull(genericType.getAnnotation(Indexed.class));
        AnnotatedGenericBeanDefinition bean = new AnnotatedGenericBeanDefinition(indexed ? GenericIndexedRepository.class : GenericRepository.class);
        bean.setAutowireCandidate(true);
        bean.setAutowireMode(2);
        ConstructorArgumentValues conVal = new ConstructorArgumentValues();
        conVal.addGenericArgumentValue(genericType);
        bean.setConstructorArgumentValues(conVal);
        String beanName = (indexed ? "Indexed" : "") + "GenericRepository_" + genericType.getSimpleName();
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
        GenericRepository repo = (GenericRepository)registry.getBean(beanName);
        if (indexed) {
            Collection<IndexSearcher<IndexSearcher>> searchers = this.registerIndexSearcher(registry, genericType, repo);
            this.indexSearchers.putIfAbsent(genericType, CollectionUtils.newMap());
            searchers.forEach(s -> this.indexSearchers.get(genericType).put(s.getClass(), (IndexSearcher<?>)s));
        }
        return repo;
    }

    private <T> Collection<IndexSearcher<T>> registerIndexSearcher(DefaultListableBeanFactory registry, Class<T> genericType, GenericRepository<T> repo) {
        List searchers = CollectionUtils.newList();
        boolean spatial = Objects.nonNull(genericType.getAnnotation(Spatial.class));
        if (spatial) {
            AnnotatedGenericBeanDefinition bean = new AnnotatedGenericBeanDefinition(SpatialIndexSearcher.class);
            bean.setAutowireCandidate(true);
            bean.setAutowireMode(2);
            ConstructorArgumentValues conVal = new ConstructorArgumentValues();
            conVal.addGenericArgumentValue(repo);
            bean.setConstructorArgumentValues(conVal);
            String beanName = "SpatialIndexSearcher_" + genericType.getSimpleName();
            registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
            searchers.add((IndexSearcher)registry.getBean(beanName));
        }
        return searchers;
    }

    @Override
    public <R extends GenericRepository<T>, T> R getRepository(Class<T> cls) {
        if (!this.repositories.containsKey(cls)) {
            throw new RuntimeException("No Repository for class " + cls.getSimpleName() + " available.");
        }
        return (R)this.repositories.get(cls);
    }

    @Override
    public <R extends GenericIndexedRepository<T>, T> R getIndexedRepository(Class<T> cls) {
        GenericRepository<?> genericRepository = this.repositories.get(cls);
        if (genericRepository instanceof GenericIndexedRepository) {
            return (R)((GenericIndexedRepository)genericRepository);
        }
        throw new RuntimeException("No GenericIndexedRepository for class " + cls.getSimpleName() + " available.");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        AbstractApplicationContext appCon = (AbstractApplicationContext)applicationContext;
        this.repositories = CollectionUtils.newMap();
        this.indexSearchers = CollectionUtils.newMap();
        if (Objects.nonNull(this.autoWiredRepositories)) {
            this.autoWiredRepositories.forEach(r -> this.repositories.putIfAbsent(r.getType(), (GenericRepository<?>)r));
        }
        Predicate<Class> conKey = this.repositories::containsKey;
        DefaultListableBeanFactory registry = (DefaultListableBeanFactory)appCon.getBeanFactory();
        this.jpaConfig.getMappedClasses().getAnnotatedClasses().stream().filter(conKey.negate()).forEach(c -> this.repositories.put((Class<?>)c, this.registerRepositoryBean(registry, (Class)c)));
    }

    @Override
    public <S extends IndexSearcher<T>, T> S getIndexSearcher(Class<S> searcherClass, Class<T> type) {
        return (S)((IndexSearcher)this.indexSearchers.getOrDefault(type, Collections.emptyMap()).getOrDefault(searcherClass, null));
    }
}

