/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.hibernate.config;

import at.chrl.orm.hibernate.HibernateService;
import at.chrl.orm.hibernate.configuration.IHibernateConfig;
import at.chrl.orm.hibernate.configuration.JPAConfig;
import at.chrl.spring.generics.repositories.utils.RepositoryTransactionPool;
import at.chrl.spring.generics.repositories.utils.impl.RepositoryTransactionPoolImplementation;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import at.chrl.spring.hibernate.config.SessionTemplateFactoryImpl;
import at.chrl.spring.hibernate.config.SpringGeneratedJpaConfig;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableAsync
@EnableTransactionManagement
public class SessionConfig
implements TransactionManagementConfigurer {
    @Autowired(required=true)
    private SpringGeneratedJpaConfig jpaConfig;

    @Bean(destroyMethod="close")
    public HibernateService getHibernateService() {
        return HibernateService.getInstance();
    }

    @Bean
    public RepositoryTransactionPool getRepositoryThreadPool() {
        return new RepositoryTransactionPoolImplementation();
    }

    @Bean(destroyMethod="")
    public EntityManagerFactory getEntityManagerFactory() {
        HibernateService.getInstance().connect((IHibernateConfig)this.jpaConfig);
        return this.getHibernateService().getEntityManagerFactory((JPAConfig)this.jpaConfig);
    }

    @Bean(destroyMethod="")
    public SessionFactory getSessionFactory() {
        HibernateService.getInstance().connect((IHibernateConfig)this.jpaConfig);
        return this.getHibernateService().getSessionFactory((IHibernateConfig)this.jpaConfig);
    }

    @Bean
    public SessionTemplateFactory getSessionTemplateFactory() {
        return new SessionTemplateFactoryImpl();
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new JpaTransactionManager(this.getEntityManagerFactory());
    }
}

