/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.rss;

import com.rometools.rome.feed.rss.Item;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.feed.AbstractRssFeedView;

@Component
public abstract class GenericRSSView<T>
extends AbstractRssFeedView {
    public static String MODEL_DATA_KEY = "model.data.key";

    protected GenericRSSView() {
    }

    protected List<Item> buildFeedItems(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.convertAll(model.getOrDefault(MODEL_DATA_KEY, Collections.emptyList()));
    }

    public abstract Item convert(T var1);

    public final List<Item> convertAll(Collection<T> toConvert) {
        return toConvert.stream().filter(Objects::nonNull).map(t -> this.convertFailSafe(t)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private final Item convertFailSafe(T toConvert) {
        try {
            return this.convert(toConvert);
        }
        catch (Exception e) {
            System.err.println("Error during RSS Item conversion: " + e.getMessage());
            return null;
        }
    }
}

