/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories.utils.impl;

import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.spring.generics.repositories.utils.impl.TransactionQueue;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.function.BiConsumer;

public final class TransactionThread {
    private final Thread thread;
    private SessionTemplateFactory sessionFactory;
    private SessionTemplate session;
    private int i = 0;
    private BlockingQueue<Object> processQueue;
    private BiConsumer<SessionTemplate, Object> function;
    private Collection<BiConsumer<SessionTemplate, Object>> afterFunctionHooks;

    public TransactionThread(final BlockingQueue<Object> processQueue, SessionTemplateFactory sessionFactory, TransactionQueue transactionQueue) {
        this.processQueue = processQueue;
        this.sessionFactory = sessionFactory;
        this.function = transactionQueue.getFunction();
        this.afterFunctionHooks = new ArrayList<BiConsumer<SessionTemplate, Object>>(transactionQueue.getAfterFunctionHooks());
        this.thread = new Thread(() -> {
            for (Object object : new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){

                        @Override
                        public Object next() {
                            try {
                                return processQueue.take();
                            }
                            catch (InterruptedException e) {
                                System.err.println("[Stop Transaction Thread] " + Thread.currentThread().getName());
                                return null;
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            return !processQueue.isEmpty();
                        }
                    };
                }
            }) {
                this.process(object);
            }
            transactionQueue.threadFinished(this);
        });
        this.thread.setName("TransactionThread_" + System.nanoTime());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private final SessionTemplate getSession() {
        if (Objects.nonNull(this.session)) {
            return this.session;
        }
        this.session = this.sessionFactory.createTemplate();
        return this.session;
    }

    public void process(Object f) {
        if (Objects.isNull(f)) {
            return;
        }
        try {
            this.function.accept(this.getSession(), f);
            this.afterFunctionHooks.forEach(h -> h.accept(this.getSession(), f));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.processQueue.isEmpty() || ++this.i % 1500 == 0) {
            this.i = 0;
            try {
                this.session.close();
                this.session = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }
}

