/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories.utils.impl;

import at.chrl.nutils.CollectionUtils;
import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.spring.generics.repositories.utils.impl.TransactionThread;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;

public class TransactionQueue {
    public static final int BATCH_SIZE = 1500;
    public static final double STEP = 0.007;
    private final int maxThreadPoolSize;
    private volatile double threshold = 0.007;
    private BlockingQueue<Object> processFunctionQueue = new LinkedBlockingQueue<Object>();
    private Collection<TransactionThread> workingThreads = new ConcurrentLinkedQueue<TransactionThread>();
    private SessionTemplateFactory sessionTemplateFactory;
    private CountDownLatch lock = null;
    private BiConsumer<SessionTemplate, Object> function;
    private Collection<BiConsumer<SessionTemplate, Object>> afterFunctionHooks;

    public TransactionQueue(int maxThreadPoolSize, SessionTemplateFactory sessionTemplateFactory, BiConsumer<SessionTemplate, Object> function) {
        this.sessionTemplateFactory = sessionTemplateFactory;
        this.function = function;
        this.afterFunctionHooks = CollectionUtils.newSet();
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    void addToQueue(Object o) {
        if (this.processFunctionQueue.size() >= 150000) {
            this.lock = new CountDownLatch(1);
        }
        if (Objects.nonNull(this.lock)) {
            try {
                this.lock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.processFunctionQueue.add(o);
        float load = this.processFunctionQueue.size();
        if ((double)load >= Math.sqrt(this.threshold) * 1500.0) {
            this.newThread(1);
        }
        if (this.workingThreads.isEmpty()) {
            this.threshold = 0.007;
            this.newThread(1);
        }
    }

    private void newThread(int count) {
        int c = Math.min(this.maxThreadPoolSize - this.workingThreads.size(), count);
        for (int i = 0; i < c; ++i) {
            this.workingThreads.add(new TransactionThread(this.processFunctionQueue, this.sessionTemplateFactory, this));
            this.threshold += 0.007;
        }
    }

    void threadFinished(TransactionThread t) {
        this.workingThreads.remove(t);
        this.threshold -= 0.007;
        if (Objects.nonNull(this.lock)) {
            this.lock.countDown();
            if (this.lock.getCount() <= 0L) {
                this.lock = null;
            }
        }
    }

    BiConsumer<SessionTemplate, Object> getFunction() {
        return this.function;
    }

    public Collection<BiConsumer<SessionTemplate, Object>> getAfterFunctionHooks() {
        return this.afterFunctionHooks;
    }

    public void addAfterFunctionHook(BiConsumer<SessionTemplate, Object> afterFunctionHook) {
        this.afterFunctionHooks.add(afterFunctionHook);
    }
}

