/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories.utils.impl;

import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.spring.generics.repositories.utils.RepositoryTransactionPool;
import at.chrl.spring.generics.repositories.utils.impl.TransactionQueue;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import at.chrl.spring.hibernate.config.SpringGeneratedJpaConfig;
import java.util.function.BiConsumer;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.hibernate.Session;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.jpa.HibernateEntityManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Transactional;

public class RepositoryTransactionPoolImplementation
implements RepositoryTransactionPool,
ApplicationContextAware {
    @Autowired
    private SessionTemplateFactory sessionTemplateFactory;
    @Autowired
    private SpringGeneratedJpaConfig jpaConfig;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    protected EntityManager entityManager;
    private TransactionQueue asyncPersistTransactionQueue;
    private TransactionQueue asyncRefreshTransactionQueue;
    private TransactionQueue asyncMergeTransactionQueue;
    private TransactionQueue asyncSaveTransactionQueue;
    private TransactionQueue asyncSaveOrUpdateTransactionQueue;
    private TransactionQueue asyncDeleteTransactionQueue;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        int maxCon = 100;
        try {
            maxCon = Integer.parseInt(this.jpaConfig.HIBERNATE_HIKARI_MAXIMUMPOOLSIZE);
        }
        catch (Exception e2) {
            System.err.println("[Transaction Pool] Error parsing maximum pool size");
        }
        this.asyncPersistTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.persist(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.asyncRefreshTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.refresh(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.asyncMergeTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.merge(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.asyncSaveTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.save(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.asyncSaveOrUpdateTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.saveOrUpdate(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.asyncDeleteTransactionQueue = new TransactionQueue(maxCon, this.sessionTemplateFactory, (sf, o) -> {
            try {
                sf.delete(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Session getSession() {
        return ((HibernateEntityManager)this.entityManager.unwrap(HibernateEntityManager.class)).getSession();
    }

    @Override
    @Transactional
    public String getIdentifierPropertyName(Class<?> cls) {
        return this.getSession().getSessionFactory().getClassMetadata(cls).getIdentifierPropertyName();
    }

    @Override
    public AuditReader getAuditReader() {
        return AuditReaderFactory.get((EntityManager)this.entityManager);
    }

    @Override
    public <T> void asyncPersist(T entity) {
        this.asyncPersistTransactionQueue.addToQueue(entity);
    }

    @Override
    public <T> void asyncRefresh(T entity) {
        this.asyncRefreshTransactionQueue.addToQueue(entity);
    }

    @Override
    public <T> void asyncMerge(T entity) {
        this.asyncMergeTransactionQueue.addToQueue(entity);
    }

    @Override
    public <T> void asyncSave(T entity) {
        this.asyncSaveTransactionQueue.addToQueue(entity);
    }

    @Override
    public <T> void asyncSaveOrUpdate(T entity) {
        this.asyncSaveOrUpdateTransactionQueue.addToQueue(entity);
    }

    @Override
    public <T> void asyncDelete(T entity) {
        this.asyncDeleteTransactionQueue.addToQueue(entity);
    }

    @Override
    public SessionTemplate getSessionTemplate() {
        return this.sessionTemplateFactory.createTemplate();
    }

    @Override
    @Deprecated
    public void addAfterFunctionHook(BiConsumer<SessionTemplate, Object> function) {
    }
}

