/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories.utils;

import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public final class SpringUtils {
    public static <T> T generateBean(ApplicationContext context, Class<T> cls, String name, Object ... args) {
        AbstractApplicationContext appCon = (AbstractApplicationContext)context;
        DefaultListableBeanFactory registry = (DefaultListableBeanFactory)appCon.getBeanFactory();
        AnnotatedGenericBeanDefinition bean = new AnnotatedGenericBeanDefinition(cls);
        bean.setAutowireCandidate(true);
        bean.setAutowireMode(2);
        ConstructorArgumentValues conVal = new ConstructorArgumentValues();
        for (Object object : args) {
            conVal.addGenericArgumentValue(object);
        }
        bean.setConstructorArgumentValues(conVal);
        String beanName = name + "_" + cls.getSimpleName();
        registry.registerBeanDefinition(beanName, (BeanDefinition)bean);
        return (T)registry.getBean(beanName);
    }
}

