/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories;

import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.spring.generics.repositories.GenericIndexedRepository;
import at.chrl.spring.generics.repositories.IndexSearcher;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.lucene.search.Query;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;

public class SpatialIndexSearcher<T>
extends IndexSearcher<T> {
    public SpatialIndexSearcher(GenericIndexedRepository<T> repository) {
        super(repository);
    }

    public void radiusSearch(double latitude, double longitude, double radius, Consumer<Stream<T>> streamConsumer) {
        QueryBuilder builder = this.repository.getFullTextSession().getSearchFactory().buildQueryBuilder().forEntity(this.getType()).get();
        Query luceneQuery = builder.spatial().within(radius, Unit.KM).ofLatitude(latitude).andLongitude(longitude).createQuery();
        FullTextQuery hibQuery = this.repository.getFullTextSession().createFullTextQuery(luceneQuery, new Class[]{this.getType()});
        this.repository.process(arg_0 -> SpatialIndexSearcher.lambda$radiusSearch$25(streamConsumer, (org.hibernate.Query)hibQuery, arg_0));
    }

    public void boxSearch(double southWestLat, double southWestLon, double northEastLat, double northEastLon, Consumer<Stream<T>> streamConsumer) {
        double kmLat = (northEastLat - southWestLat) * 110.574;
        double kmLon = Math.cos((southWestLon - northEastLon) * Math.PI / 180.0) * 111.32;
        this.radiusSearch((northEastLat + southWestLat) / 2.0, (northEastLon + southWestLon) / 2.0, Math.sqrt(kmLat * kmLat + kmLon * kmLon) / 2.0, streamConsumer);
    }

    private static /* synthetic */ void lambda$radiusSearch$25(Consumer consumer, org.hibernate.Query query, SessionTemplate s) {
        consumer.accept(s.stream(query));
    }
}

