/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories;

import at.chrl.spring.generics.repositories.GenericIndexedRepository;
import at.chrl.spring.hibernate.config.RepositoryHolder;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IndexSearcher<T> {
    @Autowired
    protected RepositoryHolder repositoryHolder;
    protected GenericIndexedRepository<T> repository;

    public IndexSearcher(GenericIndexedRepository<T> repository) {
        this.repository = repository;
    }

    protected Stream<T> search(Function<FullTextEntityManager, Stream<T>> func) {
        return func.apply(this.repository.getFullTextEntityManager());
    }

    protected Stream<T> searchWithSession(Function<FullTextSession, Stream<T>> func) {
        return func.apply(this.repository.getFullTextSession());
    }

    public Class<T> getType() {
        return this.repository.getType();
    }
}

