/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories;

import at.chrl.nutils.ClassUtils;
import at.chrl.nutils.CollectionUtils;
import at.chrl.orm.hibernate.ExtendedSessionTemplate;
import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.spring.generics.repositories.utils.RepositoryTransactionPool;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.hibernate.Session;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.jpa.HibernateEntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GenericRepository<T> {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    protected EntityManager entityManager;
    private final Class<T> persistentClass;
    private String idFieldName;
    @Autowired
    protected RepositoryTransactionPool transactionPool;
    @Autowired
    protected SessionTemplateFactory sessionTemplateFactory;

    public Session getSession() {
        return ((HibernateEntityManager)this.entityManager.unwrap(HibernateEntityManager.class)).getSession();
    }

    public GenericRepository() {
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public GenericRepository(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public Class<T> getType() {
        return this.persistentClass;
    }

    protected String getIdFieldName() {
        if (Objects.isNull(this.idFieldName)) {
            this.setIdFieldName();
        }
        return this.idFieldName;
    }

    @PostConstruct
    private void setIdFieldName() {
        this.idFieldName = this.transactionPool.getIdentifierPropertyName(this.persistentClass);
    }

    @Transactional
    public Map<Date, T> getOlderVersions(Object id) {
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisions = reader.getRevisions(this.getType(), id).stream().collect(Collectors.toList());
        List<Object> collect = revisions.stream().map(n -> reader.find(this.getType(), id, n)).collect(Collectors.toList());
        List dates = revisions.stream().map(arg_0 -> ((AuditReader)reader).getRevisionDate(arg_0)).collect(Collectors.toList());
        collect.forEach(arg_0 -> ((EntityManager)this.entityManager).detach(arg_0));
        Map returnMe = CollectionUtils.newMap();
        int to = Math.min(collect.size(), dates.size());
        for (int i = 0; i < to; ++i) {
            returnMe.put(dates.get(i), collect.get(i));
        }
        return returnMe;
    }

    public String toString() {
        return ClassUtils.getString((Object)this, (Function[])new Function[]{new Function<GenericRepository<T>, String>(){

            @Override
            public String apply(GenericRepository<T> t) {
                return t.getType().getSimpleName();
            }
        }});
    }

    public void process(Consumer<SessionTemplate> consumer) {
        try (ExtendedSessionTemplate session = this.sessionTemplateFactory.createTemplate(this.entityManager);){
            consumer.accept((SessionTemplate)session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public void persist(T entity) {
        this.entityManager.persist(entity);
    }

    @Transactional
    public void refresh(T entity) {
        this.entityManager.refresh(entity);
    }

    @Transactional
    public T merge(T entity) {
        return (T)this.entityManager.merge(entity);
    }

    @Transactional
    public void save(T entity) {
        this.getSession().save(entity);
    }

    @Transactional
    public void saveOrUpdate(T entity) {
        this.getSession().saveOrUpdate(entity);
    }

    @Transactional
    public void delete(T entity) {
        try {
            this.getSession().delete(entity);
        }
        catch (IllegalArgumentException e) {
            this.getSession().delete(this.getSession().merge(entity));
        }
    }

    @Transactional
    public T getById(Serializable id) {
        return (T)this.getSession().get(this.persistentClass, id);
    }

    public void getByIds(Collection<Serializable> ids, Consumer<Stream<T>> streamConsumer) {
        this.process(s -> streamConsumer.accept(s.streamObjectsForPK(this.persistentClass, ids)));
    }

    public void getAll(int maxResults, Consumer<Collection<T>> collectionConsumer) {
        this.process(s -> collectionConsumer.accept(s.getAll(this.persistentClass, maxResults)));
    }

    public Collection<T> getAll() {
        return this.getAll(0);
    }

    public Collection<T> getAll(int maxResults) {
        List col = CollectionUtils.newList();
        this.getAll(maxResults, c -> col.addAll(c));
        return col;
    }

    public void asyncPersist(T entity) {
        this.transactionPool.asyncPersist(entity);
    }

    public void asyncRefresh(T entity) {
        this.transactionPool.asyncRefresh(entity);
    }

    public void asyncMerge(T entity) {
        this.transactionPool.asyncMerge(entity);
    }

    public void asyncSave(T entity) {
        this.transactionPool.asyncSave(entity);
    }

    public void asyncSaveOrUpdate(T entity) {
        this.transactionPool.asyncSaveOrUpdate(entity);
    }

    public void asyncDelete(T entity) {
        this.transactionPool.asyncDelete(entity);
    }

    public void asyncPersist(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncPersist(entity));
    }

    public void asyncRefresh(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncRefresh(entity));
    }

    public void asyncMerge(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncMerge(entity));
    }

    public void asyncSave(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncSave(entity));
    }

    public void asyncSaveOrUpdate(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncSaveOrUpdate(entity));
    }

    public void asyncDelete(Collection<T> entities) {
        entities.forEach(entity -> this.transactionPool.asyncDelete(entity));
    }

    public void asyncPersist(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncPersist(entity));
    }

    public void asyncRefresh(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncRefresh(entity));
    }

    public void asyncMerge(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncMerge(entity));
    }

    public void asyncSave(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncSave(entity));
    }

    public void asyncSaveOrUpdate(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncSaveOrUpdate(entity));
    }

    public void asyncDelete(T ... entities) {
        Arrays.stream(entities).forEach(entity -> this.transactionPool.asyncDelete(entity));
    }
}

