/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories;

import at.chrl.orm.hibernate.configuration.JPAConfig;
import at.chrl.spring.generics.repositories.GenericRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.exception.EmptyQueryException;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericIndexedRepository<T>
extends GenericRepository<T> {
    @Autowired
    protected JPAConfig jpaConfig;
    protected FullTextEntityManager fullTextEntityManager;
    protected FullTextSession fullTextSession;

    public GenericIndexedRepository(Class<T> cls) {
        super(cls);
    }

    public GenericIndexedRepository() {
    }

    public FullTextEntityManager getFullTextEntityManager() {
        if (Objects.isNull(this.fullTextEntityManager)) {
            this.fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.transactionPool.getEntityManager());
        }
        return this.fullTextEntityManager;
    }

    public FullTextSession getFullTextSession() {
        if (Objects.isNull(this.fullTextSession)) {
            this.fullTextSession = org.hibernate.search.Search.getFullTextSession((Session)this.transactionPool.getSession());
        }
        return this.fullTextSession;
    }

    public void updateIndex() {
        System.out.println("Updating index for " + this.getType().getSimpleName());
        this.updateIndexPrivate();
        System.out.println("Updating index for " + this.getType().getSimpleName() + " finished");
    }

    private void updateIndexPrivate() {
        try {
            int batchSize;
            FullTextSession fullTextSession = this.getFullTextSession();
            fullTextSession.setFlushMode(FlushMode.MANUAL);
            fullTextSession.setCacheMode(CacheMode.IGNORE);
            Transaction transaction = fullTextSession.beginTransaction();
            try {
                batchSize = Integer.parseInt(this.jpaConfig.DEFAULT_BATCH_FETCH_SIZE);
            }
            catch (Exception e) {
                batchSize = 500;
            }
            ScrollableResults results = fullTextSession.createCriteria(this.getType()).setFetchSize(batchSize).scroll(ScrollMode.FORWARD_ONLY);
            int index = 0;
            while (results.next()) {
                fullTextSession.index(results.get(0));
                if (++index % batchSize != 0) continue;
                fullTextSession.flushToIndexes();
                fullTextSession.clear();
            }
            transaction.commit();
        }
        catch (NullPointerException e) {
            this.fullTextEntityManager = Search.getFullTextEntityManager((EntityManager)this.transactionPool.getEntityManager());
            this.updateIndexPrivate();
        }
        catch (Exception e) {
            System.out.println("Error rebuilding index: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Collection<T> searchIndex(String searchString, String ... fields) {
        Query createQuery;
        QueryBuilder qb = this.getFullTextEntityManager().getSearchFactory().buildQueryBuilder().forEntity(this.getType()).get();
        try {
            createQuery = qb.bool().must(qb.keyword().onFields(fields).matching((Object)searchString).createQuery()).createQuery();
        }
        catch (EmptyQueryException e) {
            System.out.println("Index Search for " + this.getType().getSimpleName() + " | " + searchString.toString() + " | no hits");
            return Collections.emptyList();
        }
        FullTextQuery ftq = this.getFullTextEntityManager().createFullTextQuery(createQuery, new Class[]{this.getType()});
        System.out.println("Index Search for " + this.getType().getSimpleName() + " | " + createQuery.toString() + " | " + ftq.getResultSize() + " hits");
        return ftq.getResultList();
    }
}

