/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.hibernate.config;

import at.chrl.orm.hibernate.HibernateService;
import at.chrl.orm.hibernate.SessionTemplate;
import at.chrl.orm.hibernate.configuration.IHibernateConfig;
import at.chrl.orm.hibernate.configuration.JPAConfig;
import at.chrl.spring.hibernate.config.SessionTemplateFactory;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableTransactionManagement
public class SpringJpaConfig
implements TransactionManagementConfigurer {
    @Autowired(required=true)
    JPAConfig jpaConfig;
    @Autowired(required=true)
    public HibernateService hibernateService;

    @Bean(destroyMethod="")
    public EntityManagerFactory getEntityManagerFactory() {
        HibernateService.getInstance().connect((IHibernateConfig)this.jpaConfig);
        return this.getHibernateService().getEntityManagerFactory(this.jpaConfig);
    }

    @Bean(destroyMethod="")
    public SessionFactory getSessionFactory() {
        HibernateService.getInstance().connect((IHibernateConfig)this.jpaConfig);
        return this.getHibernateService().getSessionFactory((IHibernateConfig)this.jpaConfig);
    }

    @Bean
    public SessionTemplateFactory getSessionTemplateFactory() {
        return new SessionTemplateFactory(){

            @Override
            public SessionTemplate createTemplate() {
                return new SessionTemplateImplementation();
            }
        };
    }

    @Bean(destroyMethod="close")
    public HibernateService getHibernateService() {
        return HibernateService.getInstance();
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new JpaTransactionManager(this.getEntityManagerFactory());
    }

    private static class SessionTemplateImplementation
    extends SessionTemplate {
        @Autowired(required=true)
        JPAConfig jpaConfig;

        private SessionTemplateImplementation() {
        }

        protected IHibernateConfig getHibernateConfig() {
            return this.jpaConfig;
        }
    }
}

