/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.spring.generics.repositories.controller;

import at.chrl.spring.generics.repositories.GenericRepository;
import at.chrl.spring.generics.rss.EmptyRSSView;
import at.chrl.spring.generics.rss.IRSSController;
import java.util.Collection;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class RepositoryController<R extends GenericRepository<T>, T> {
    private final Supplier<ModelAndView> rssSupplier = this instanceof IRSSController ? () -> ((IRSSController)((Object)this)).getRss(((GenericRepository)this.repo).getLast(100)) : () -> new ModelAndView((View)new EmptyRSSView());
    @Autowired(required=true)
    protected R repo;

    @RequestMapping(value={"get"})
    public T getById(@RequestParam(value="id") int id) {
        return ((GenericRepository)this.repo).getById(id);
    }

    @RequestMapping(value={"getall"})
    public Collection<T> getAll(@RequestParam(value="maxResults", defaultValue="100") int maxResults) {
        return ((GenericRepository)this.repo).getAll(maxResults);
    }

    @RequestMapping(value={"hql"})
    public Collection<T> getByHql(@RequestParam(value="query") String query, @RequestParam(value="maxResults", defaultValue="0") int maxResults) {
        return ((GenericRepository)this.repo).executeHQLQuery(query, maxResults);
    }

    @RequestMapping(value={"sql"})
    public Collection<T> getBySql(@RequestParam(value="query") String query, @RequestParam(value="maxResults", defaultValue="0") int maxResults) {
        return ((GenericRepository)this.repo).executeSQLQuery(query, maxResults);
    }

    @RequestMapping(value={"named"})
    public Collection<T> getByNamedQuery(@RequestParam(value="query") String query, @RequestParam(value="maxResults", defaultValue="0") int maxResults) {
        return ((GenericRepository)this.repo).executeNamedQuery(query, maxResults);
    }

    @RequestMapping(value={"count"})
    public long getCount() {
        return ((GenericRepository)this.repo).count();
    }

    @RequestMapping(value={"rss"})
    public ModelAndView getRssFeed() {
        return this.rssSupplier.get();
    }
}

